/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RemoteRuleMatch {
    private final String ruleId;
    private final String msg;
    private final String context;
    private final int contextOffset;
    private final int offset;
    private final int errorLength;
    private String subId;
    private String shortMsg;
    private List<String> replacements;
    private String url;
    private String category;
    private String categoryId;
    private String locQualityIssueType;

    RemoteRuleMatch(String ruleId, String msg, String context, int contextOffset, int offset, int errorLength) {
        this.ruleId = Objects.requireNonNull(ruleId);
        this.msg = Objects.requireNonNull(msg);
        this.context = Objects.requireNonNull(context);
        this.contextOffset = contextOffset;
        this.offset = offset;
        this.errorLength = errorLength;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public Optional<String> getRuleSubId() {
        return Optional.ofNullable(this.subId);
    }

    public String getMessage() {
        return this.msg;
    }

    public Optional<String> getShortMessage() {
        return Optional.ofNullable(this.shortMsg);
    }

    public Optional<List<String>> getReplacements() {
        return Optional.ofNullable(this.replacements);
    }

    public String getContext() {
        return this.context;
    }

    public int getContextOffset() {
        return this.contextOffset;
    }

    public int getErrorOffset() {
        return this.offset;
    }

    public int getErrorLength() {
        return this.errorLength;
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public Optional<String> getCategory() {
        return Optional.of(this.category);
    }

    public Optional<String> getCategoryId() {
        return Optional.of(this.categoryId);
    }

    public Optional<String> getLocQualityIssueType() {
        return Optional.ofNullable(this.locQualityIssueType);
    }

    void setRuleSubId(String subId) {
        this.subId = subId;
    }

    void setShortMsg(String shortMsg) {
        this.shortMsg = shortMsg;
    }

    void setReplacements(List<String> replacements) {
        this.replacements = Collections.unmodifiableList(replacements);
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setCategory(String category) {
        this.category = category;
    }

    void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    void setLocQualityIssueType(String locQualityIssueType) {
        this.locQualityIssueType = locQualityIssueType;
    }

    public String toString() {
        return this.ruleId + "@" + this.offset + "-" + (this.offset + this.errorLength);
    }
}

