/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.languagetool.remote.CheckConfiguration;

public class CheckConfigurationBuilder {
    private final String langCode;
    private String motherTongueLangCode;
    private boolean autoDetectLanguage;
    private boolean enabledOnly;
    private List<String> enabledRuleIds = new ArrayList<String>();
    private List<String> disabledRuleIds = new ArrayList<String>();

    public CheckConfigurationBuilder(String langCode) {
        this.langCode = Objects.requireNonNull(langCode);
    }

    public CheckConfigurationBuilder() {
        this.langCode = null;
        this.autoDetectLanguage = true;
    }

    public CheckConfiguration build() {
        if (this.enabledOnly && this.enabledRuleIds.size() == 0) {
            throw new IllegalStateException("You cannot use 'enabledOnly' when you haven't set rule ids to be enabled");
        }
        return new CheckConfiguration(this.langCode, this.motherTongueLangCode, this.autoDetectLanguage, this.enabledRuleIds, this.enabledOnly, this.disabledRuleIds);
    }

    public CheckConfigurationBuilder setMotherTongueLangCode(String motherTongueLangCode) {
        this.motherTongueLangCode = motherTongueLangCode;
        return this;
    }

    public CheckConfigurationBuilder enabledRuleIds(List<String> ruleIds) {
        this.enabledRuleIds = Objects.requireNonNull(ruleIds);
        return this;
    }

    public CheckConfigurationBuilder enabledRuleIds(String ... ruleIds) {
        return this.enabledRuleIds(Arrays.asList(ruleIds));
    }

    public CheckConfigurationBuilder enabledOnly() {
        this.enabledOnly = true;
        return this;
    }

    public CheckConfigurationBuilder disabledRuleIds(List<String> ruleIds) {
        this.disabledRuleIds = Objects.requireNonNull(ruleIds);
        return this;
    }

    public CheckConfigurationBuilder disabledRuleIds(String ... ruleIds) {
        return this.disabledRuleIds(Arrays.asList(ruleIds));
    }
}

