/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wordsimilarity;

import org.languagetool.dev.wordsimilarity.KeyboardDistance;

public abstract class BaseKeyboardDistance
implements KeyboardDistance {
    abstract char[][] getKeys();

    @Override
    public float getDistance(char c1, char c2) {
        Position p1 = this.getPosition(c1);
        Position p2 = this.getPosition(c2);
        return p1.distanceTo(p2);
    }

    private Position getPosition(char searchKey) {
        char searchKeyLowerCase = Character.toLowerCase(searchKey);
        int row = -1;
        int column = -1;
        int rowCount = 0;
        for (char[] rowKeys : this.getKeys()) {
            int columnCount = 0;
            for (char c : rowKeys) {
                if (c == searchKeyLowerCase) {
                    row = rowCount;
                    column = columnCount;
                }
                ++columnCount;
            }
            ++rowCount;
        }
        if (row == -1 || column == -1) {
            throw new RuntimeException("Could not find '" + searchKey + "' on keyboard - only letters are supported");
        }
        return new Position(row, column);
    }

    static class Position {
        int row;
        int column;

        Position(int row, int column) {
            this.row = row;
            this.column = column;
        }

        float distanceTo(Position other) {
            return Math.abs(this.column - other.column) + Math.abs(this.row - other.row);
        }

        public String toString() {
            return "Position{row=" + this.row + ", column=" + this.column + "}";
        }
    }
}

