/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wiktionary;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HomophoneExtractor {
    private static final Pattern homophonePattern = Pattern.compile("\\{\\{homophones\\|(.*?)\\}\\}");

    private void run(String filename) throws FileNotFoundException {
        try (Scanner scanner = new Scanner(new File(filename));){
            String title = "";
            int lineCount = 0;
            long startTime = System.currentTimeMillis();
            while (scanner.hasNextLine()) {
                Matcher m;
                String line = scanner.nextLine();
                ++lineCount;
                if (line.contains("<title>") && line.contains("</title>")) {
                    title = line.substring(line.indexOf("<title>") + 7, line.indexOf("</title>"));
                } else if (line.contains("lang=en") && (m = homophonePattern.matcher(line)).find()) {
                    String homophonesData = m.group(1).replaceFirst("\\|?lang=en\\|?", "");
                    String[] homophones = homophonesData.split("\\|");
                    ArrayList<String> allHomophones = new ArrayList<String>();
                    allHomophones.add(title);
                    allHomophones.addAll(Arrays.asList(homophones));
                    allHomophones.sort(null);
                    System.out.println(String.join((CharSequence)", ", allHomophones));
                }
                if (lineCount % 100000 != 0) continue;
                long endTime = System.currentTimeMillis();
                System.err.println(lineCount + " (" + (endTime - startTime) + "ms)...");
                startTime = System.currentTimeMillis();
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length != 1) {
            System.out.println("Usage: " + HomophoneExtractor.class.getSimpleName() + " <xmlFilename>");
            System.out.println("       <xmlFilename> is an unpacked Wiktionary dump");
            System.exit(1);
        }
        HomophoneExtractor extractor = new HomophoneExtractor();
        extractor.run(args[0]);
    }
}

