/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class SpellCheckEvaluation {
    private static final int MAX_SUGGESTIONS = 5;

    private void run(Language language, File file) throws IOException {
        JLanguageTool lt = this.getLanguageToolForSpellCheck(language);
        this.checkFile(file, lt);
    }

    private JLanguageTool getLanguageToolForSpellCheck(Language language) {
        JLanguageTool lt = new JLanguageTool(language);
        for (Rule rule : lt.getAllActiveRules()) {
            if (rule.isDictionaryBasedSpellingRule()) continue;
            lt.disableRule(rule.getId());
        }
        return lt;
    }

    private void checkFile(File file, JLanguageTool lt) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)fis, "utf-8");
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                List matches = lt.check(line);
                for (RuleMatch match : matches) {
                    String covered = line.substring(match.getFromPos(), match.getToPos());
                    List suggestions = match.getSuggestedReplacements();
                    List limitedSuggestions = suggestions.subList(0, Math.min(5, suggestions.size()));
                    System.out.println(covered + ": " + limitedSuggestions);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + SpellCheckEvaluation.class.getSimpleName() + " <langCode> <textFile>");
            System.exit(1);
        }
        SpellCheckEvaluation eval = new SpellCheckEvaluation();
        eval.run(Languages.getLanguageForShortCode((String)args[0]), new File(args[1]));
    }
}

