/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.dev.errorcorpus.ErrorCorpus;
import org.languagetool.dev.errorcorpus.ErrorSentence;
import org.languagetool.dev.errorcorpus.PedlerCorpus;
import org.languagetool.dev.eval.Evaluator;
import org.languagetool.dev.eval.FMeasure;
import org.languagetool.dev.eval.LanguageToolEvaluator;
import org.languagetool.dev.eval.Span;
import org.languagetool.rules.RuleMatch;

class RealWordCorpusEvaluator {
    private final Evaluator evaluator;
    private final List<String> badConfusionMatchWords = new ArrayList<String>();
    private int sentenceCount;
    private int errorsInCorpusCount;
    private int perfectMatches;
    private int goodMatches;
    private int matchCount;
    private int perfectConfusionMatches;
    private int goodConfusionMatches;
    private int badConfusionMatches;

    RealWordCorpusEvaluator(File indexDir) throws IOException {
        this.evaluator = this.getEvaluator(indexDir);
    }

    @NotNull
    protected Evaluator getEvaluator(File indexTopDir) throws IOException {
        LanguageToolEvaluator checker = new LanguageToolEvaluator(indexTopDir);
        return checker;
    }

    @NotNull
    protected ErrorCorpus getCorpus(File dir) throws IOException {
        return new PedlerCorpus(dir);
    }

    void close() {
        this.evaluator.close();
    }

    int getSentencesChecked() {
        return this.sentenceCount;
    }

    int getErrorsChecked() {
        return this.errorsInCorpusCount;
    }

    int getRealErrorsFound() {
        return this.goodMatches;
    }

    int getRealErrorsFoundWithGoodSuggestion() {
        return this.perfectMatches;
    }

    void run(File dir) throws IOException {
        System.out.println("Output explanation:");
        System.out.println("    [  ] = this is not an expected error");
        System.out.println("    [+ ] = this is an expected error");
        System.out.println("    [++] = this is an expected error and the first suggestion is correct");
        System.out.println("    [//]  = not counted because already matches by a different rule");
        System.out.println();
        ErrorCorpus corpus = this.getCorpus(dir);
        this.checkLines(corpus);
        this.printResults();
    }

    private void checkLines(ErrorCorpus corpus) throws IOException {
        for (ErrorSentence sentence : corpus) {
            List<RuleMatch> matches = this.evaluator.check(sentence.getAnnotatedText());
            ++this.sentenceCount;
            this.errorsInCorpusCount += sentence.getErrors().size();
            System.out.println(sentence.getMarkupText() + " => " + matches.size());
            for (RuleMatch match : matches) {
                int length = match.getToPos() - match.getFromPos();
                System.out.println(StringUtils.repeat((String)" ", (int)match.getFromPos()) + StringUtils.repeat((String)"^", (int)length));
            }
            ArrayList<Span> detectedErrorPositions = new ArrayList<Span>();
            for (RuleMatch match : matches) {
                boolean alreadyCounted = this.errorAlreadyCounted(match, detectedErrorPositions);
                if (!alreadyCounted && sentence.hasErrorCoveredByMatchAndGoodFirstSuggestion(match)) {
                    ++this.goodMatches;
                    ++this.perfectMatches;
                    ++this.matchCount;
                    if (this.isConfusionRule(match)) {
                        ++this.perfectConfusionMatches;
                    }
                    System.out.println("    [++] " + match + ": " + match.getSuggestedReplacements());
                } else if (!alreadyCounted && sentence.hasErrorCoveredByMatch(match)) {
                    ++this.goodMatches;
                    ++this.matchCount;
                    if (this.isConfusionRule(match)) {
                        ++this.goodConfusionMatches;
                    }
                    System.out.println("    [+ ] " + match + ": " + match.getSuggestedReplacements());
                } else if (alreadyCounted) {
                    System.out.println("    [//]  " + match + ": " + match.getSuggestedReplacements());
                } else {
                    System.out.println("    [  ] " + match + ": " + match.getSuggestedReplacements());
                    ++this.matchCount;
                    if (this.isConfusionRule(match)) {
                        ++this.badConfusionMatches;
                        this.badConfusionMatchWords.add(sentence.getMarkupText().substring(match.getFromPos(), match.getToPos()));
                    }
                }
                detectedErrorPositions.add(new Span(match.getFromPos(), match.getToPos()));
            }
        }
    }

    private boolean isConfusionRule(RuleMatch match) {
        return match.getRule().getId().equals("CONFUSION_RULE");
    }

    private void printResults() {
        System.out.println();
        System.out.println(this.sentenceCount + " lines checked with " + this.errorsInCorpusCount + " errors.");
        System.out.println("Confusion rule matches: " + this.perfectConfusionMatches + " perfect, " + this.goodConfusionMatches + " good, " + this.badConfusionMatches + " bad (" + this.badConfusionMatchWords + ")");
        System.out.println("\nCounting matches, no matter whether the first suggestion is correct:");
        System.out.print("  " + this.goodMatches + " out of " + this.matchCount + " matches are real errors");
        float goodPrecision = (float)this.goodMatches / (float)this.matchCount;
        float goodRecall = (float)this.goodMatches / (float)this.errorsInCorpusCount;
        System.out.printf(" => %.2f precision, %.2f recall\n", Float.valueOf(goodPrecision), Float.valueOf(goodRecall));
        System.out.printf("  => %.4f F(0.5) measure\n", FMeasure.getWeightedFMeasure(goodPrecision, goodRecall));
        System.out.println("\nCounting only matches with a perfect first suggestion:");
        System.out.print("  " + this.perfectMatches + " out of " + this.matchCount + " matches are real errors");
        float perfectPrecision = (float)this.perfectMatches / (float)this.matchCount;
        float perfectRecall = (float)this.perfectMatches / (float)this.errorsInCorpusCount;
        System.out.printf(" => %.2f precision, %.2f recall\n", Float.valueOf(perfectPrecision), Float.valueOf(perfectRecall));
        System.out.printf("  => %.4f F(0.5) measure\n", FMeasure.getWeightedFMeasure(perfectPrecision, perfectRecall));
    }

    private boolean errorAlreadyCounted(RuleMatch match, List<Span> detectedErrorPositions) {
        for (Span span : detectedErrorPositions) {
            Span matchSpan;
            if (!span.covers(matchSpan = new Span(match.getFromPos(), match.getToPos())) && !matchSpan.covers(span)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1 && args.length != 2) {
            System.out.println("Usage: " + RealWordCorpusEvaluator.class.getSimpleName() + " <corpusDirectory> [languageModel]");
            System.out.println("   [languageModel] is a Lucene index directory with ngram frequency information (optional)");
            System.exit(1);
        }
        File languageModelTopDir = null;
        if (args.length == 1) {
            System.out.println("Running without language model");
        } else {
            languageModelTopDir = new File(args[1]);
            System.out.println("Running with language model from " + languageModelTopDir);
        }
        RealWordCorpusEvaluator evaluator = new RealWordCorpusEvaluator(languageModelTopDir);
        evaluator.run(new File(args[0]));
        evaluator.close();
    }
}

