/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.eval.Evaluator;
import org.languagetool.language.BritishEnglish;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.EnglishConfusionProbabilityRule;

class LanguageToolEvaluator
implements Evaluator {
    private final JLanguageTool lt = new JLanguageTool((Language)BritishEnglish.getInstance());
    private final LanguageModel languageModel;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LanguageToolEvaluator(File indexTopDir) throws IOException {
        this.disableRules();
        if (indexTopDir != null) {
            if (!indexTopDir.isDirectory()) throw new RuntimeException("Does not exist or not a directory: " + indexTopDir);
            this.languageModel = new LuceneLanguageModel(indexTopDir);
            System.out.println("Using Lucene language model from " + this.languageModel);
            EnglishConfusionProbabilityRule probabilityRule = new EnglishConfusionProbabilityRule(JLanguageTool.getMessageBundle(), this.languageModel, (Language)new English());
            this.lt.addRule((Rule)probabilityRule);
            return;
        } else {
            this.languageModel = null;
        }
    }

    @Override
    public void close() {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    private void disableRules() {
        this.lt.disableRule("COMMA_PARENTHESIS_WHITESPACE");
        this.lt.disableRule("SENT_START_CONJUNCTIVE_LINKING_ADVERB_COMMA");
        this.lt.disableRule("EN_QUOTES");
        this.lt.disableRule("I_LOWERCASE");
        this.lt.disableRule("LITTLE_BIT");
        this.lt.disableRule("ALL_OF_THE");
        this.lt.disableRule("SOME_OF_THE");
        this.lt.disableRule("EN_GB_SIMPLE_REPLACE");
        this.lt.disableRule("APARTMENT-FLAT");
    }

    @Override
    public List<RuleMatch> check(AnnotatedText annotatedText) throws IOException {
        return this.lt.check(annotatedText);
    }
}

