/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.errorcorpus;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.languagetool.dev.errorcorpus.Error;
import org.languagetool.dev.errorcorpus.ErrorCorpus;
import org.languagetool.dev.errorcorpus.ErrorSentence;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;

public class SimpleCorpus
implements ErrorCorpus {
    private final List<String> lines = new ArrayList<String>();
    private int pos;

    public SimpleCorpus(File simpleTextFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(simpleTextFile);){
            this.lines.addAll(IOUtils.readLines((InputStream)fis).stream().filter(line -> line.matches("\\d+\\..*")).collect(Collectors.toList()));
        }
        System.out.println("Loaded " + this.lines.size() + " example sentences");
    }

    @Override
    public Iterator<ErrorSentence> iterator() {
        return new Iterator<ErrorSentence>(){

            @Override
            public boolean hasNext() {
                return SimpleCorpus.this.pos < SimpleCorpus.this.lines.size();
            }

            @Override
            public ErrorSentence next() {
                String line = SimpleCorpus.this.lines.get(SimpleCorpus.this.pos++);
                return SimpleCorpus.this.getIncorrectSentence(line);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private ErrorSentence getIncorrectSentence(String line) {
        String normalized = line.replaceFirst("\\d+\\.\\s*", "");
        String normalizedNoCorrection = normalized.replaceFirst("=>.*", "").trim();
        int startError = normalized.indexOf(95);
        int endError = normalized.indexOf(95, startError + 1);
        if (startError == -1 || endError == -1) {
            throw new RuntimeException("No '_..._' marker found: " + line);
        }
        int startCorrectionMarker = normalized.indexOf("=>");
        if (startCorrectionMarker == -1) {
            throw new RuntimeException("No '=>' marker found: " + line);
        }
        String correction = normalized.substring(startCorrectionMarker + "=>".length());
        List<Error> errors = Arrays.asList(new Error(startError + 1, endError - 1, correction));
        return new ErrorSentence(normalizedNoCorrection, this.makeAnnotatedText(normalizedNoCorrection), errors);
    }

    private AnnotatedText makeAnnotatedText(String text) {
        AnnotatedTextBuilder builder = new AnnotatedTextBuilder();
        builder.addText(text.replace("_", " ").replaceAll("\\s+", " "));
        return builder.build();
    }
}

