/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.errorcorpus;

import java.util.List;
import org.languagetool.dev.errorcorpus.Error;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RuleMatch;

public class ErrorSentence {
    private final String markupText;
    private final AnnotatedText annotatedText;
    private final List<Error> errors;

    ErrorSentence(String markupText, AnnotatedText annotatedText, List<Error> errors) {
        this.markupText = markupText;
        this.annotatedText = annotatedText;
        this.errors = errors;
    }

    public boolean hasErrorCoveredByMatchAndGoodFirstSuggestion(RuleMatch match) {
        List suggestion;
        if (this.hasErrorCoveredByMatch(match) && (suggestion = match.getSuggestedReplacements()).size() > 0) {
            String firstSuggestion = (String)suggestion.get(0);
            for (Error error : this.errors) {
                String correctedByCorpus = error.getAppliedCorrection(this.markupText);
                String correctedByRuleMarkup = this.markupText.substring(0, match.getFromPos()) + (String)match.getSuggestedReplacements().get(0) + this.markupText.substring(match.getToPos());
                String correctedByRule = correctedByRuleMarkup.replaceAll("<.*?>", "");
                if (correctedByRule.equals(correctedByCorpus)) {
                    return true;
                }
                if (!error.getCorrection().equalsIgnoreCase(firstSuggestion)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasErrorCoveredByMatch(RuleMatch match) {
        for (Error error : this.errors) {
            if (match.getFromPos() > error.getStartPos() || match.getToPos() < error.getEndPos()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrorOverlappingWithMatch(RuleMatch match) {
        for (Error error : this.errors) {
            if (!(match.getFromPos() <= error.getStartPos() && match.getToPos() >= error.getEndPos() || match.getFromPos() >= error.getStartPos() && match.getFromPos() <= error.getEndPos()) && (match.getToPos() < error.getStartPos() || match.getToPos() > error.getEndPos())) continue;
            return true;
        }
        return false;
    }

    public String getMarkupText() {
        return this.markupText;
    }

    public AnnotatedText getAnnotatedText() {
        return this.annotatedText;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public String toString() {
        return this.markupText;
    }
}

