/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.errorcorpus;

public class Error {
    private final int startPos;
    private final int endPos;
    private final String correction;

    Error(int startPos, int endPos, String correction) {
        if (endPos < startPos) {
            throw new RuntimeException("end pos < start pos: " + endPos + " < " + startPos);
        }
        this.startPos = startPos;
        this.endPos = endPos;
        this.correction = correction;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public String getCorrection() {
        return this.correction;
    }

    public String getAppliedCorrection(String markupText) {
        try {
            String correctionApplied = markupText.substring(0, this.startPos) + this.correction + markupText.substring(this.endPos);
            return correctionApplied.replaceAll("<.*?>", "");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get substrings 0-" + this.startPos + " and " + this.endPos + "-end: " + markupText);
        }
    }

    public String toString() {
        return this.startPos + "-" + this.endPos + ":" + this.correction;
    }
}

