/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.diff;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.languagetool.dev.diff.LightRuleMatch;

class RuleMatchDiff {
    private final Status status;
    private final LightRuleMatch oldMatch;
    private final LightRuleMatch newMatch;
    private final LightRuleMatch replacedBy;
    private LightRuleMatch replaces;

    static RuleMatchDiff added(LightRuleMatch newMatch) {
        return new RuleMatchDiff(Status.ADDED, null, newMatch, null);
    }

    static RuleMatchDiff removed(LightRuleMatch oldMatch) {
        return new RuleMatchDiff(Status.REMOVED, oldMatch, null, null);
    }

    static RuleMatchDiff removed(LightRuleMatch oldMatch, LightRuleMatch replacedBy) {
        return new RuleMatchDiff(Status.REMOVED, oldMatch, null, replacedBy);
    }

    static RuleMatchDiff modified(LightRuleMatch oldMatch, LightRuleMatch newMatch) {
        return new RuleMatchDiff(Status.MODIFIED, oldMatch, newMatch, null);
    }

    private RuleMatchDiff(Status status, LightRuleMatch oldMatch, LightRuleMatch newMatch, LightRuleMatch replacedBy) {
        this.status = Objects.requireNonNull(status);
        this.oldMatch = oldMatch;
        this.newMatch = newMatch;
        this.replacedBy = replacedBy;
    }

    Status getStatus() {
        return this.status;
    }

    String getMarkedText() {
        return this.newMatch == null ? this.oldMatch.getCoveredText() : this.newMatch.getCoveredText();
    }

    @Nullable
    LightRuleMatch getOldMatch() {
        return this.oldMatch;
    }

    @Nullable
    LightRuleMatch getNewMatch() {
        return this.newMatch;
    }

    LightRuleMatch getReplacedBy() {
        return this.replacedBy;
    }

    void setReplaces(LightRuleMatch oldMatch) {
        this.replaces = oldMatch;
    }

    LightRuleMatch getReplaces() {
        return this.replaces;
    }

    public String toString() {
        return this.status + ": oldMatch=" + this.oldMatch + ", newMatch=" + this.newMatch;
    }

    static enum Status {
        ADDED,
        REMOVED,
        MODIFIED;

    }
}

