/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.diff;

import java.util.Objects;
import org.languagetool.dev.diff.DiffTools;

class MatchKey {
    private final int line;
    private final int column;
    private final String ruleId;
    private final String subId;
    private final String title;
    private final String coveredText;

    MatchKey(int line, int column, String ruleId, String title, String coveredText) {
        this.line = line;
        this.column = column;
        this.ruleId = DiffTools.getMasterId(ruleId);
        this.subId = DiffTools.getSubId(ruleId);
        this.title = title.trim();
        this.coveredText = Objects.requireNonNull(coveredText);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchKey matchKey = (MatchKey)o;
        return this.line == matchKey.line && this.column == matchKey.column && this.ruleId.equals(matchKey.ruleId) && Objects.equals(this.title, matchKey.title) && this.coveredText.equals(matchKey.coveredText);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column, this.ruleId, this.title, this.coveredText);
    }

    public String toString() {
        return "MatchKey{line=" + this.line + ", column=" + this.column + ", ruleId='" + this.ruleId + "', title='" + this.title + "', coveredText='" + this.coveredText + "'}";
    }
}

