/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.dev.diff.LightRuleMatch;

class LightRuleMatchParser {
    private final Pattern startPattern = Pattern.compile("^(?:\\d+\\.\\) )?Line (\\d+), column (\\d+), Rule ID: (.*) premium: (false|true)");
    private final Pattern coverPattern = Pattern.compile("^([ ^]+)$");

    LightRuleMatchParser() {
    }

    JsonParseResult parseOutput(File inputFile) throws IOException {
        if (inputFile.getName().endsWith(".json")) {
            return this.parseAggregatedJson(inputFile);
        }
        return this.parseOutput(new FileReader(inputFile));
    }

    @NotNull
    private JsonParseResult parseAggregatedJson(File inputFile) {
        System.out.println("Parsing " + inputFile + "...");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<LightRuleMatch> ruleMatches = new ArrayList<LightRuleMatch>();
        HashSet<String> buildDates = new HashSet<String>();
        int lineCount = 1;
        try (Scanner scanner = new Scanner(inputFile);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                JsonNode node = mapper.readTree(line);
                JsonNode matches = node.get("matches");
                JsonNode software = node.get("software");
                String buildDate = software != null ? software.get("buildDate").asText() : "unknown";
                buildDates.add(buildDate);
                for (JsonNode match : matches) {
                    ruleMatches.add(this.nodeToLightMatch(node.get("title").asText(), match));
                }
                ++lineCount;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse line " + lineCount + " of " + inputFile, e);
        }
        return new JsonParseResult(ruleMatches, buildDates);
    }

    @NotNull
    private LightRuleMatch nodeToLightMatch(String title, JsonNode match) {
        int offset = match.get("offset").asInt();
        JsonNode rule = match.get("rule");
        String ruleId = rule.get("id").asText();
        String fullRuleId = rule.get("subId") != null ? ruleId + "[" + rule.get("subId").asText() + "]" : ruleId;
        String message = match.get("message").asText();
        String category = rule.get("category") != null ? rule.get("category").get("name").asText() : "(unknown)";
        boolean isPremium = rule.get("isPremium") != null && rule.get("isPremium").asBoolean(false);
        int contextOffset = match.get("context").get("offset").asInt();
        int contextLength = match.get("context").get("length").asInt();
        String context = match.get("context").get("text").asText();
        int maxEnd = Math.min(contextOffset + contextLength, context.length());
        String coveredText = context.substring(contextOffset, contextOffset + contextLength);
        context = this.getContextWithSpan(match.get("context").get("text").asText(), contextOffset, maxEnd);
        if (match.get("sentence") != null) {
            String sentence = match.get("sentence").asText();
            if (StringUtils.countMatches((CharSequence)sentence, (CharSequence)coveredText) == 1) {
                int idx = sentence.indexOf(coveredText);
                context = this.getContextWithSpan(sentence, idx, idx + coveredText.length());
            } else {
                Object noLinebreakSentence;
                String shortContext = match.get("context").get("text").asText();
                int idxFix = 0;
                if (shortContext.startsWith("...")) {
                    shortContext = shortContext.substring(3);
                    idxFix = 3;
                }
                if (shortContext.endsWith("...")) {
                    shortContext = shortContext.substring(0, shortContext.length() - 3);
                }
                if (StringUtils.countMatches((CharSequence)(noLinebreakSentence = sentence.replace('\n', ' ')), (CharSequence)shortContext) == 1) {
                    int idx = ((String)noLinebreakSentence).indexOf(shortContext);
                    idx = idx + contextOffset - idxFix;
                    context = this.getContextWithSpan(sentence, idx, idx + coveredText.length());
                }
            }
        }
        JsonNode replacements = match.get("replacements");
        ArrayList<String> replacementList = new ArrayList<String>();
        if (replacements != null) {
            int i = 0;
            for (JsonNode replacement : replacements) {
                replacementList.add(replacement.get("value").asText());
                if (++i < 5) continue;
                break;
            }
        }
        String ruleSource = rule.get("sourceFile") != null ? rule.get("sourceFile").asText() : null;
        LightRuleMatch.Status status = LightRuleMatch.Status.on;
        if (rule.get("tempOff") != null && rule.get("tempOff").asBoolean()) {
            status = LightRuleMatch.Status.temp_off;
        }
        JsonNode jsonTags = rule.get("tags");
        ArrayList<String> tags = new ArrayList<String>();
        if (jsonTags != null) {
            for (JsonNode tag : jsonTags) {
                tags.add(tag.asText());
            }
        }
        return new LightRuleMatch(0, offset, fullRuleId, message, category, context, coveredText, replacementList, ruleSource, title, status, tags, isPremium);
    }

    JsonParseResult parseOutput(Reader reader) {
        ArrayList<LightRuleMatch> result = new ArrayList<LightRuleMatch>();
        int lineNum = -1;
        int columnNum = -1;
        String ruleId = null;
        String message = null;
        String context = null;
        String suggestion = null;
        String source = null;
        String title = null;
        boolean isPremium = false;
        Scanner sc = new Scanner(reader);
        while (sc.hasNextLine()) {
            String coveredText;
            String line = sc.nextLine();
            Matcher startMatcher = this.startPattern.matcher(line);
            Matcher coverMatcher = this.coverPattern.matcher(line);
            if (line.startsWith("Message: ")) {
                message = line.substring("Message: ".length());
                continue;
            }
            if (line.startsWith("Suggestion: ")) {
                suggestion = line.substring("Suggestion: ".length());
                continue;
            }
            if (line.startsWith("Rule source: ")) {
                source = line.substring("Rule source: ".length());
                continue;
            }
            if (line.startsWith("Title: ")) {
                title = line.substring("Title: ".length());
                continue;
            }
            if (startMatcher.matches()) {
                lineNum = Integer.parseInt(startMatcher.group(1));
                columnNum = Integer.parseInt(startMatcher.group(2));
                ruleId = startMatcher.group(3);
                isPremium = Boolean.parseBoolean(startMatcher.group(4));
                continue;
            }
            if ((suggestion != null || message != null) && context == null) {
                context = line;
                continue;
            }
            if (!coverMatcher.matches() || !line.contains("^")) continue;
            String cover = coverMatcher.group(1);
            int startMarkerPos = cover.indexOf(94);
            int endMarkerPos = cover.lastIndexOf(94) + 1;
            String origContext = context;
            try {
                int maxEnd = Math.min(endMarkerPos, context.length());
                coveredText = context.substring(startMarkerPos, maxEnd);
                context = this.getContextWithSpan(context, startMarkerPos, maxEnd);
            }
            catch (StringIndexOutOfBoundsException e) {
                System.err.println("Cannot get context, setting to '???':");
                System.err.println(origContext);
                System.err.println(cover);
                coveredText = "???";
            }
            String cleanId = ruleId.replace("[off]", "").replace("[temp_off]", "");
            ArrayList<String> tags = new ArrayList<String>();
            result.add(this.makeMatch(lineNum, columnNum, ruleId, cleanId, message, Arrays.asList(suggestion), context, coveredText, title, source, tags, isPremium));
            lineNum = -1;
            columnNum = -1;
            ruleId = null;
            message = null;
            context = null;
            suggestion = null;
            source = null;
        }
        return new JsonParseResult(result, Collections.singleton("unknown"));
    }

    @NotNull
    private String getContextWithSpan(String context, int startMarkerPos, int maxEnd) {
        context = ((String)context).substring(0, startMarkerPos) + "<span class='marker'>" + ((String)context).substring(startMarkerPos, maxEnd) + "</span>" + ((String)context).substring(maxEnd);
        return context;
    }

    private LightRuleMatch makeMatch(int line, int column, String ruleId, String cleanId, String message, List<String> suggestions, String context, String coveredText, String title, String source, List<String> tags, boolean isPremium) {
        LightRuleMatch.Status s = ruleId.contains("[temp_off]") ? LightRuleMatch.Status.temp_off : LightRuleMatch.Status.on;
        return new LightRuleMatch(line, column, cleanId, message, "", context, coveredText, suggestions, source, title, s, tags, isPremium);
    }

    static class JsonParseResult {
        List<LightRuleMatch> result;
        Set<String> buildDates;

        JsonParseResult(List<LightRuleMatch> result, Set<String> buildDates) {
            this.result = result;
            this.buildDates = buildDates;
        }
    }
}

