/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.tools.StringTools;

final class GermanUpperLowercaseWords {
    private GermanUpperLowercaseWords() {
    }

    @NotNull
    private static Set<String> getUppercaseWords(List<String> lines) {
        HashSet<String> uppercaseWords = new HashSet<String>();
        for (String line : lines) {
            if (!StringTools.startsWithUppercase((String)line)) continue;
            uppercaseWords.add(line);
        }
        return uppercaseWords;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + GermanUpperLowercaseWords.class.getSimpleName() + " <wordList>");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
        Set<String> uppercaseWords = GermanUpperLowercaseWords.getUppercaseWords(lines);
        for (String line : lines) {
            String uppercased = StringTools.uppercaseFirstChar((String)line);
            if (StringTools.startsWithUppercase((String)line) || !uppercaseWords.contains(uppercased)) continue;
            System.out.println(line + "; " + uppercased);
        }
    }
}

