/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.synthesis.Synthesizer;

final class GermanReflexiveVerbGuesser {
    private final Synthesizer synthesizer = GermanyGerman.getInstance().getSynthesizer();

    private GermanReflexiveVerbGuesser() {
    }

    private void run(File indexTopDir, File lemmaListFile) throws IOException {
        List<String> lemmas = Files.readAllLines(lemmaListFile.toPath());
        System.out.println("Durchschnitt Prozent | Anzahl Lemma | mich/uns/euch ... | ... mich/uns/euch | Lemma");
        try (LuceneLanguageModel lm = new LuceneLanguageModel(indexTopDir);){
            for (String lemma : lemmas) {
                String[] firstPsSinArray = this.synthesizer.synthesize(new AnalyzedToken(lemma, "VER:INF:NON", lemma), "VER:1:SIN:PR\u00c4.*", true);
                String[] thirdPsSinArray = this.synthesizer.synthesize(new AnalyzedToken(lemma, "VER:INF:NON", lemma), "VER:3:SIN:PR\u00c4.*", true);
                String firstPsSin = firstPsSinArray.length > 0 ? firstPsSinArray[0] : null;
                String thirdPsSin = thirdPsSinArray.length > 0 ? thirdPsSinArray[0] : null;
                long reflexiveCount1 = this.count1(lm, lemma, firstPsSin, thirdPsSin) - this.counterExamples("f\u00fcr", lm, lemma, firstPsSin, thirdPsSin) - this.counterExamples("vor", lm, lemma, firstPsSin, thirdPsSin);
                long reflexiveCount2 = this.count2(lm, lemma, firstPsSin, thirdPsSin);
                long lemmaCount = lm.getCount(lemma);
                float factor1 = (float)reflexiveCount1 / (float)lemmaCount * 100.0f;
                float factor2 = (float)reflexiveCount2 / (float)lemmaCount * 100.0f;
                float avgFactor = (factor1 + factor2) / 2.0f;
                System.out.printf("%.2f %d %.2f%% %.2f%% %s\n", Float.valueOf(avgFactor), lemmaCount, Float.valueOf(factor1), Float.valueOf(factor2), lemma);
            }
        }
    }

    private long count1(LuceneLanguageModel lm, String lemma, String firstPsSin, String thirdPsSin) {
        return lm.getCount(Arrays.asList("mich", firstPsSin)) + lm.getCount(Arrays.asList("mich", lemma)) + lm.getCount(Arrays.asList("sich", thirdPsSin)) + lm.getCount(Arrays.asList("uns", lemma)) + lm.getCount(Arrays.asList("euch", lemma)) + lm.getCount(Arrays.asList("sich", lemma));
    }

    private long counterExamples(String term, LuceneLanguageModel lm, String lemma, String firstPsSin, String thirdPsSin) {
        return lm.getCount(Arrays.asList(term, "mich", firstPsSin)) + lm.getCount(Arrays.asList(term, "mich", lemma)) + lm.getCount(Arrays.asList(term, "sich", thirdPsSin)) + lm.getCount(Arrays.asList(term, "uns", lemma)) + lm.getCount(Arrays.asList(term, "euch", lemma)) + lm.getCount(Arrays.asList(term, "sich", lemma));
    }

    private long count2(LuceneLanguageModel lm, String lemma, String firstPsSin, String thirdPsSin) {
        return lm.getCount(Arrays.asList(firstPsSin, "mich")) + lm.getCount(Arrays.asList(thirdPsSin, "sich")) + lm.getCount(Arrays.asList(lemma, "uns")) + lm.getCount(Arrays.asList(lemma, "sich"));
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + GermanReflexiveVerbGuesser.class.getName() + " <ngramDataIndex> <verbLemmaFile>");
            System.exit(1);
        }
        String indexTopDir = args[0];
        String lemmaListFile = args[1];
        new GermanReflexiveVerbGuesser().run(new File(indexTopDir), new File(lemmaListFile));
    }
}

