/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.archive;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;

public final class WordTokenizer {
    public static void main(String[] args) throws IOException {
        WordTokenizer prg = new WordTokenizer();
        if (args.length != 1) {
            System.err.println("Please supply the language code as the only argument.");
            System.exit(-1);
        }
        prg.run(args[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String lang) throws IOException {
        JLanguageTool lt = new JLanguageTool(Languages.getLanguageForShortCode((String)lang));
        BufferedWriter out = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(System.in));){
            String line;
            out = new BufferedWriter(new OutputStreamWriter(System.out));
            while ((line = in.readLine()) != null) {
                AnalyzedTokenReadings[] atr;
                for (AnalyzedTokenReadings a : atr = lt.getRawAnalyzedSentence(line).getTokensWithoutWhitespace()) {
                    out.write(a.getToken());
                    out.write(10);
                }
            }
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

