/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.archive;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRule;

final class UselessExampleFinder {
    private int uselessExampleCount;
    private int removedLinesCount;

    UselessExampleFinder() {
    }

    private void run(Language lang) throws IOException {
        File basePath = new File("/lt/git/languagetool/languagetool-language-modules");
        if (!basePath.exists()) {
            throw new RuntimeException("basePath does not exist: " + basePath);
        }
        String langCode = lang.getShortCode();
        File xml = new File(basePath, "/" + langCode + "/src/main/resources/org/languagetool/rules/" + langCode + "/grammar.xml");
        List xmlLines = IOUtils.readLines((Reader)new FileReader(xml));
        JLanguageTool tool = new JLanguageTool(lang);
        for (Rule rule : tool.getAllActiveRules()) {
            if (!(rule instanceof PatternRule)) continue;
            List correctExamples = rule.getCorrectExamples();
            List incorrectExamples = rule.getIncorrectExamples();
            for (IncorrectExample incorrectExample : incorrectExamples) {
                this.checkCorrections(rule, correctExamples, incorrectExample, xmlLines);
            }
        }
        System.err.println("Useless examples: " + this.uselessExampleCount);
        System.err.println("Removed lines: " + this.removedLinesCount);
        for (String xmlLine : xmlLines) {
            System.out.println(xmlLine);
        }
    }

    private void checkCorrections(Rule rule, List<CorrectExample> correctExamplesObjs, IncorrectExample incorrectExample, List<String> xmlLines) {
        List correctExamples = correctExamplesObjs.stream().map(k -> k.getExample()).collect(Collectors.toList());
        List corrections = incorrectExample.getCorrections();
        for (String correction : corrections) {
            String fixedSentence = incorrectExample.getExample().replaceAll("<marker>.*?</marker>", "<marker>" + correction.replace("$", "\\$") + "</marker>");
            String fixedSentenceNoMarker = incorrectExample.getExample().replaceAll("<marker>.*?</marker>", correction.replace("$", "\\$"));
            if (correctExamples.contains(fixedSentence)) {
                System.err.println("Useless: " + fixedSentence + " in " + rule.getId());
                this.removeLinesFromXml(rule, fixedSentence, xmlLines);
                ++this.uselessExampleCount;
            }
            if (!correctExamples.contains(fixedSentenceNoMarker)) continue;
            System.err.println("Useless: " + fixedSentenceNoMarker + " in " + rule.getId());
            this.removeLinesFromXml(rule, fixedSentenceNoMarker, xmlLines);
            ++this.uselessExampleCount;
        }
    }

    private void removeLinesFromXml(Rule rule, String sentenceToRemove, List<String> xmlLines) {
        ArrayList<Integer> linesToRemove = new ArrayList<Integer>();
        String currentRuleId = null;
        Pattern pattern = Pattern.compile(".*id=[\"'](.*?)[\"'].*");
        String expectedSubId = ((AbstractPatternRule)rule).getSubId();
        int lineCount = 0;
        int subRuleCount = 0;
        int removedCount = 0;
        boolean inRuleGroup = false;
        for (String xmlLine : xmlLines) {
            if (xmlLine.contains("<rulegroup")) {
                subRuleCount = 0;
                inRuleGroup = true;
            } else if (xmlLine.contains("</rulegroup>")) {
                subRuleCount = 0;
                inRuleGroup = false;
            } else if ((xmlLine.contains("<rule ") || xmlLine.contains("<rule>")) && inRuleGroup) {
                ++subRuleCount;
            }
            Matcher m = pattern.matcher(xmlLine);
            if (m.matches()) {
                currentRuleId = m.group(1);
            }
            if (!xmlLine.contains("correction=") && xmlLine.contains(sentenceToRemove + "</example>")) {
                if (currentRuleId != null && !currentRuleId.equals(rule.getId())) {
                    ++lineCount;
                    continue;
                }
                if (!inRuleGroup) {
                    subRuleCount = 1;
                }
                if (!expectedSubId.equals("0") && !expectedSubId.equals(String.valueOf(subRuleCount))) {
                    ++lineCount;
                    continue;
                }
                linesToRemove.add(lineCount);
                break;
            }
            ++lineCount;
        }
        Collections.reverse(linesToRemove);
        for (Integer s : linesToRemove) {
            xmlLines.remove(s);
            ++this.removedLinesCount;
            ++removedCount;
        }
        if (removedCount == 0) {
            System.err.println("No line removed: " + rule + "[" + expectedSubId + "]");
        }
    }

    public static void main(String[] args) throws IOException {
        UselessExampleFinder prg = new UselessExampleFinder();
        prg.run(Languages.getLanguageForShortCode((String)"de"));
    }
}

