/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.archive;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;

public class SimpleRuleCounter {
    private void run(List<Language> languages) {
        ArrayList<Language> sortedLanguages = new ArrayList<Language>(languages);
        sortedLanguages.sort(Comparator.comparing(Language::getName));
        for (Language language : sortedLanguages) {
            if (language.isVariant()) continue;
            JLanguageTool lt = new JLanguageTool(language);
            List allRules = lt.getAllActiveRules();
            this.countForLanguage(allRules, language);
        }
    }

    private void countForLanguage(List<Rule> allRules, Language language) {
        int simpleCount = 0;
        for (Rule rule : allRules) {
            boolean isSimple = true;
            if (!(rule instanceof PatternRule)) continue;
            PatternRule patternRule = (PatternRule)rule;
            List tokens = patternRule.getPatternTokens();
            for (PatternToken token : tokens) {
                if (this.isSimple(token)) continue;
                isSimple = false;
                break;
            }
            if (!isSimple) continue;
            ++simpleCount;
        }
        float percent = (float)simpleCount / (float)allRules.size() * 100.0f;
        System.out.printf("%.0f%% for " + language + "\n", Float.valueOf(percent));
    }

    private boolean isSimple(PatternToken t) {
        return !t.getNegation() && !t.getPOSNegation() && !t.hasAndGroup() && !t.hasExceptionList() && !t.hasNextException() && !t.hasOrGroup() && !t.isInflected() && !t.isPOStagRegularExpression() && t.getPOStag() == null && !t.isReferenceElement() && !t.isSentenceStart() && t.getSkipNext() == 0;
    }

    public static void main(String[] args) {
        SimpleRuleCounter finder = new SimpleRuleCounter();
        finder.run(Languages.get());
    }
}

