/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.archive;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.languagetool.JLanguageTool;
import org.languagetool.language.GermanyGerman;
import org.languagetool.tagging.Tagger;
import org.languagetool.tools.StringTools;

public class GermanTaggerEnhancer {
    private static final String[] ADJ_READINGS = new String[]{"ADJ:NOM:SIN:MAS:GRU", "ADJ:NOM:SIN:NEU:GRU", "ADJ:NOM:SIN:FEM:GRU", "ADJ:GEN:SIN:MAS:GRU", "ADJ:GEN:SIN:NEU:GRU", "ADJ:GEN:SIN:FEM:GRU", "ADJ:DAT:SIN:MAS:GRU", "ADJ:DAT:SIN:NEU:GRU", "ADJ:DAT:SIN:FEM:GRU", "ADJ:AKK:SIN:MAS:GRU", "ADJ:AKK:SIN:NEU:GRU", "ADJ:AKK:SIN:FEM:GRU", "ADJ:NOM:PLU:MAS:GRU", "ADJ:NOM:PLU:NEU:GRU", "ADJ:NOM:PLU:FEM:GRU", "ADJ:GEN:PLU:MAS:GRU", "ADJ:GEN:PLU:NEU:GRU", "ADJ:GEN:PLU:FEM:GRU", "ADJ:DAT:PLU:MAS:GRU", "ADJ:DAT:PLU:NEU:GRU", "ADJ:DAT:PLU:FEM:GRU", "ADJ:AKK:PLU:MAS:GRU", "ADJ:AKK:PLU:NEU:GRU", "ADJ:AKK:PLU:FEM:GRU"};

    private void run() throws IOException {
        Dictionary dictionary = Dictionary.read((URL)JLanguageTool.getDataBroker().getFromResourceDirAsUrl("/de/german.dict"));
        DictionaryLookup dl = new DictionaryLookup(dictionary);
        Tagger tagger = GermanyGerman.getInstance().getTagger();
        String prev = null;
        for (WordData wd : dl) {
            String word = wd.getWord().toString();
            if (!word.endsWith("er") || !StringTools.startsWithUppercase((String)word) || this.hasAnyPosTagStartingWith(tagger, word, "ADJ:NOM") || !this.hasAnyPosTagStartingWith(tagger, word.substring(0, word.length() - 2), "EIG") || word.equals(prev)) continue;
            for (String newTags : ADJ_READINGS) {
                System.out.println(word + "\t" + word + "\t" + newTags + ":DEF\n" + word + "\t" + word + "\t" + newTags + ":IND\n" + word + "\t" + word + "\t" + newTags + ":SOL");
            }
            prev = word;
        }
    }

    private boolean hasAnyPosTagStartingWith(Tagger tagger, String word, String initialPosTag) throws IOException {
        List readings = tagger.tag(Collections.singletonList(word));
        return readings.stream().anyMatch(atr -> atr.hasPosTagStartingWith(initialPosTag));
    }

    public static void main(String[] args) throws IOException {
        GermanTaggerEnhancer enhancer = new GermanTaggerEnhancer();
        enhancer.run();
    }
}

