/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class XmlIndenter {
    private static final int INDENT = 2;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + XmlIndenter.class.getSimpleName() + " <xmlFile>");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]), StandardCharsets.UTF_8);
        boolean inCategory = false;
        boolean inRuleGroup = false;
        boolean inRule = false;
        boolean inAntiPattern = false;
        boolean inPattern = false;
        boolean inMarker = false;
        boolean inAnd = false;
        boolean inUnify = false;
        boolean inUnifyIgnore = false;
        boolean inToken = false;
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line;
            String origLine = line = iterator.next();
            if ((line = line.trim()).contains("</marker>") && (inPattern || inAntiPattern)) {
                inMarker = false;
            }
            if (line.startsWith("</antipattern>")) {
                inAntiPattern = false;
            }
            if (line.startsWith("</pattern>")) {
                inPattern = false;
            }
            if (line.startsWith("</rule>")) {
                inRule = false;
            }
            if (line.startsWith("</rulegroup")) {
                inRuleGroup = false;
            }
            if (line.startsWith("</category")) {
                inCategory = false;
            }
            if (line.startsWith("</and")) {
                inAnd = false;
            }
            if (line.startsWith("</unify>")) {
                inUnify = false;
            }
            if (line.startsWith("</unify-ignore>")) {
                inUnifyIgnore = false;
            }
            int level = 2 + (inCategory ? 2 : 0) + (inRuleGroup ? 2 : 0) + (inRule ? 2 : 0) + (inPattern ? 2 : 0) + (inAntiPattern ? 2 : 0) + (inMarker ? 2 : 0) + (inToken ? 2 : 0) + (inAnd ? 2 : 0) + (inUnify ? 2 : 0) + (inUnifyIgnore ? 2 : 0);
            if (line.startsWith("<category") || line.startsWith("</category")) {
                level = 2;
            }
            if (line.equals("</token>")) {
                level -= 2;
            }
            String indentSpaces = StringUtils.repeat((char)' ', (int)level);
            if (!line.isEmpty() && (inCategory || line.startsWith("<category") || line.startsWith("</category"))) {
                System.out.println(indentSpaces + line);
            } else {
                System.out.println(origLine);
            }
            if (line.startsWith("<category")) {
                inCategory = true;
            }
            if (line.startsWith("<rulegroup")) {
                inRuleGroup = true;
            }
            if (line.startsWith("<rule ") || line.startsWith("<rule>")) {
                inRule = true;
            }
            if (line.startsWith("<pattern")) {
                inPattern = true;
            }
            if (line.startsWith("<antipattern") && !line.contains("</antipattern")) {
                inAntiPattern = true;
            }
            if (line.contains("<marker>") && !line.contains("</marker>") && (inPattern || inAntiPattern)) {
                inMarker = true;
            }
            if (line.contains("<and>")) {
                inAnd = true;
            }
            if (line.contains("<unify>") || line.contains("<unify ")) {
                inUnify = true;
            }
            if (line.contains("<unify-ignore>")) {
                inUnifyIgnore = true;
            }
            if (line.contains("</token>") || line.contains("<token") && line.contains("/>") && (inPattern || inAntiPattern)) {
                inToken = false;
            }
            if (!line.contains("<token") || line.contains("/>") || line.contains("</token>") || !inPattern && !inAntiPattern) continue;
            inToken = true;
        }
    }
}

