/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.Tagger;

public class UnknownWordFinder {
    private final Map<String, Integer> unknownWords = new HashMap<String, Integer>();
    private final Set<String> unknownSpelling = new HashSet<String>();
    private final Set<String> unknownTag = new HashSet<String>();

    private void run(File dir, JLanguageTool lt) throws IOException {
        SpellingCheckRule spellerRule = this.getSpellingCheckRule(lt);
        Tagger tagger = lt.getLanguage().getTagger();
        List files = Files.walk(dir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        for (Path file : files) {
            this.handle(file, lt, spellerRule, tagger);
        }
        this.printResult(this.unknownWords);
    }

    @NotNull
    private SpellingCheckRule getSpellingCheckRule(JLanguageTool lt) {
        SpellingCheckRule spellerRule = null;
        for (Rule rule : lt.getAllActiveRules()) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            if (spellerRule != null) {
                throw new RuntimeException("Found more than one spell rule: " + rule + ", " + spellerRule);
            }
            spellerRule = (SpellingCheckRule)rule;
        }
        if (spellerRule == null) {
            throw new RuntimeException("No speller rule found for " + lt.getLanguage());
        }
        return spellerRule;
    }

    private void handle(Path f, JLanguageTool lt, SpellingCheckRule rule, Tagger tagger) throws IOException {
        String text = null;
        if (f.toString().toLowerCase().endsWith(".txt")) {
            List<String> lines = Files.readAllLines(f);
            text = String.join((CharSequence)" ", lines);
        } else if (f.toString().toLowerCase().endsWith(".rtf")) {
            text = this.getTextFromRtf(f);
        } else {
            System.out.println("Ignoring " + f + ": unknown suffix");
        }
        if (text != null) {
            System.out.println("Working on " + f);
            List analyzedSentences = lt.analyzeText(text);
            for (AnalyzedSentence analyzedSentence : analyzedSentences) {
                AnalyzedTokenReadings[] tokens;
                for (AnalyzedTokenReadings token : tokens = analyzedSentence.getTokensWithoutWhitespace()) {
                    List tags;
                    boolean noTag;
                    boolean misspelled;
                    String t = token.getToken();
                    boolean bl = misspelled = !t.matches("[\\d%$]+") && rule.isMisspelled(t);
                    if (misspelled) {
                        this.unknownSpelling.add(t);
                    }
                    boolean bl2 = noTag = (tags = tagger.tag(Collections.singletonList(t))).size() == 1 && !((AnalyzedTokenReadings)tags.get(0)).isTagged() && !t.matches("[\\d%$]+");
                    if (noTag) {
                        this.unknownTag.add(t);
                    }
                    if (!misspelled && !noTag) continue;
                    if (this.unknownWords.containsKey(t)) {
                        this.unknownWords.put(t, this.unknownWords.get(t) + 1);
                        continue;
                    }
                    this.unknownWords.put(t, 1);
                }
            }
        }
    }

    private String getTextFromRtf(Path f) throws IOException {
        JEditorPane p = new JEditorPane();
        p.setContentType("text/rtf");
        EditorKit rtfKit = p.getEditorKitForContentType("text/rtf");
        try {
            rtfKit.read(new FileReader(f.toFile()), p.getDocument(), 0);
            StringWriter writer = new StringWriter();
            EditorKit txtKit = p.getEditorKitForContentType("text/plain");
            txtKit.write(writer, p.getDocument(), 0, p.getDocument().getLength());
            return ((Object)writer).toString();
        }
        catch (BadLocationException e) {
            System.err.println("Problem running on " + f + ": " + e.getMessage());
            return null;
        }
    }

    private void printResult(Map<String, Integer> unknownWords) {
        ArrayList<CountedWord> countedWords = new ArrayList<CountedWord>();
        for (Map.Entry<String, Integer> entry : unknownWords.entrySet()) {
            countedWords.add(new CountedWord(entry.getKey(), entry.getValue()));
        }
        Collections.sort(countedWords);
        System.out.println("== RESULT ==");
        System.out.println("count\tterm\tunknownSpelling\tunknownTag");
        for (CountedWord countedWord : countedWords) {
            String t = countedWord.word;
            System.out.println(countedWord.count + "\t" + t + "\t" + this.unknownSpelling.contains(t) + "\t" + this.unknownTag.contains(t));
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + UnknownWordFinder.class.getSimpleName() + " <langCode> <dir>");
            System.exit(1);
        }
        JLanguageTool lt = new JLanguageTool(Languages.getLanguageForShortCode((String)args[0]));
        new UnknownWordFinder().run(new File(args[1]), lt);
    }

    static class CountedWord
    implements Comparable<CountedWord> {
        int count;
        String word;

        CountedWord(String key, Integer value) {
            this.word = key;
            this.count = value;
        }

        @Override
        public int compareTo(@NotNull CountedWord countedWord) {
            return Integer.compare(countedWord.count, this.count);
        }
    }
}

