/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Scanner;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;

class SentenceSplitter {
    private static final int BATCH_SIZE = 1000;

    SentenceSplitter() {
    }

    private void run(Language language, File inputFile, PrintWriter outputFile) throws IOException {
        JLanguageTool lt = new JLanguageTool(language);
        try (Scanner scanner = new Scanner(inputFile);){
            int count = 0;
            long startTime = System.currentTimeMillis();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                List sentences = lt.sentenceTokenize(line);
                for (String sentence : sentences) {
                    String cleanSentence = sentence.trim();
                    if (cleanSentence.isEmpty()) continue;
                    outputFile.println(cleanSentence);
                }
                if (++count % 1000 != 0) continue;
                long time = System.currentTimeMillis() - startTime;
                System.out.println(count + ". " + time + "ms per 1000 sentences");
                startTime = System.currentTimeMillis();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: " + SentenceSplitter.class.getSimpleName() + " <langCode> <inputFile or folderFile> <outputFile>");
            System.exit(1);
        }
        SentenceSplitter splitter = new SentenceSplitter();
        PrintWriter output = new PrintWriter(args[2]);
        File folder = new File(args[1]);
        if (folder.isFile()) {
            splitter.run(Languages.getLanguageForShortCode((String)args[0]), folder, output);
        }
        if (folder.isDirectory()) {
            for (File fileEntry : folder.listFiles()) {
                if (!fileEntry.isFile()) continue;
                splitter.run(Languages.getLanguageForShortCode((String)args[0]), fileEntry, output);
            }
        }
        output.close();
    }
}

