/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;

class SentenceChecker {
    private static final int BATCH_SIZE = 1000;

    SentenceChecker() {
    }

    private void run(Language language, File file) throws IOException {
        JLanguageTool lt = new JLanguageTool(language);
        try (Scanner scanner = new Scanner(file);){
            int count = 0;
            long startTime = System.currentTimeMillis();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                lt.check(line);
                if (++count % 1000 != 0) continue;
                long time = System.currentTimeMillis() - startTime;
                System.out.println(count + ". " + time + "ms per 1000 sentences");
                startTime = System.currentTimeMillis();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: " + SentenceChecker.class.getSimpleName() + " <langCode> <sentenceFile>");
            System.exit(1);
        }
        SentenceChecker checker = new SentenceChecker();
        checker.run(Languages.getLanguageForShortCode((String)args[0]), new File(args[1]));
    }
}

