/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.dev.RuleActivityOverview;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.Contributor;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.Rule;
import org.languagetool.rules.spelling.hunspell.HunspellNoSuggestionRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public final class RuleOverview {
    private static final List<String> langSpecificWebsites = Arrays.asList("ca", "nl", "fr", "de", "it", "pl", "pt", "ru", "es", "uk");

    public static void main(String[] args) throws IOException {
        RuleOverview prg = new RuleOverview();
        prg.run();
    }

    private RuleOverview() {
    }

    private void run() throws IOException {
        System.out.println("<p><b>Rules in LanguageTool " + JLanguageTool.VERSION + "</b><br />");
        System.out.println("Date: " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + "</p>\n");
        System.out.println("<table class=\"tablesorter sortable\" style=\"width: auto\">");
        System.out.println("<thead>");
        System.out.println("<tr>");
        System.out.println("  <th valign='bottom' width=\"200\">Language</th>");
        System.out.println("  <th valign='bottom' align=\"left\" width=\"60\">XML<br/>rules</th>");
        System.out.println("  <th></th>");
        System.out.println("  <th align=\"left\" width=\"60\">Java<br/>rules</th>");
        System.out.println("  <th align=\"left\" width=\"60\">Spell<br/>check</th>");
        System.out.println("  <th align=\"left\" width=\"60\">Confusion<br/>pairs</th>");
        System.out.println("  <th valign='bottom' align=\"left\" width=\"90\">Activity</th>");
        System.out.println("</tr>");
        System.out.println("</thead>");
        System.out.println("<tbody>");
        List<Language> sortedLanguages = this.getSortedLanguages();
        int overallJavaCount = 0;
        RuleActivityOverview activity = new RuleActivityOverview();
        for (Language lang : sortedLanguages) {
            if (lang.isVariant()) continue;
            System.out.print("<tr>");
            String langCode = lang.getShortCode();
            List<String> variants = this.getVariantNames(sortedLanguages, lang);
            Object variantsText = "";
            if (variants.size() > 0) {
                variantsText = "<br/><span class='langVariants'>Variants for: " + String.join((CharSequence)", ", variants) + "</span>";
            }
            if (langSpecificWebsites.contains(langCode)) {
                System.out.print("<td valign=\"top\"><a href=\"https://languagetool.org/" + langCode + "/\">" + lang.getName() + "</a>" + (String)variantsText + "</td>");
            } else {
                System.out.print("<td valign=\"top\">" + lang.getName() + " " + (String)variantsText + "</td>");
            }
            int allRules = this.countRulesForLanguage(lang);
            if (allRules == 0) {
                System.out.println("<td valign=\"top\" align=\"right\">0</td>");
            } else {
                String ruleBase = "https://github.com/languagetool-org/languagetool/blob/master/languagetool-language-modules/" + langCode + "/src/main/resources/org/languagetool/rules/";
                System.out.print("<td valign=\"top\" align=\"right\">" + allRules + "</td>");
                System.out.print("<td valign=\"top\" align=\"right\"><a href=\"http://community.languagetool.org/rule/list?lang=" + langCode + "\">Browse</a>,&nbsp;<a href=\"" + ruleBase + langCode + "/grammar.xml\">XML</a></td>");
            }
            File dir = new File("../languagetool-language-modules/" + langCode + "/src/main/java" + JLanguageTool.getDataBroker().getRulesDir() + "/" + langCode);
            if (!dir.exists()) {
                System.out.print("<td valign=\"top\" align=\"right\">0</td>");
            } else {
                File[] javaRules = dir.listFiles(new JavaFilter(lang.getName()));
                int javaCount = javaRules.length;
                if (javaCount > 0) {
                    String sourceCodeLink = "https://github.com/languagetool-org/languagetool/blob/master/languagetool-language-modules/" + langCode + "/src/main/java/org/languagetool/rules/" + langCode + "/";
                    System.out.print("<td valign=\"top\" align=\"right\"><a href=\"" + sourceCodeLink + "\">" + javaCount + "</a></td>");
                } else {
                    System.out.print("<td valign=\"top\" align=\"right\">" + javaCount + "</td>");
                }
                ++overallJavaCount;
            }
            SpellcheckSupport spellcheckSupport = this.spellcheckSupport(lang, sortedLanguages);
            String spellSupportStr = "";
            if (spellcheckSupport == SpellcheckSupport.Full) {
                spellSupportStr = "\u2713";
            } else if (spellcheckSupport == SpellcheckSupport.NoSuggestion) {
                spellSupportStr = "<span title='spell check without suggestions'>(\u2713)</span>";
            }
            System.out.print("<td valign=\"top\" align=\"right\">" + spellSupportStr + "</td>");
            System.out.print("<td valign=\"top\" align=\"right\">" + this.countConfusionPairs(lang) + "</td>");
            int commits = activity.getActivityFor(lang, 182);
            int width = (int)Math.max((double)commits * 0.25, 1.0);
            Object images = "";
            if (width > 50) {
                images = (String)images + "<img title='" + commits + " commits in the last 6 months' src='images/bar-end.png' width='22' height='10'/>";
                width = 50;
            } else if (width == 1 && commits > 0) {
                width = 3;
            }
            images = (String)images + "<img title='" + commits + " commits in the last 6 months' src='images/bar.png' width='" + width + "' height='10'/>";
            System.out.print("<td valign=\"top\" align=\"right\"><span style='display:none'>" + commits + "</span>" + (String)images + "</td>");
            System.out.println("</tr>");
        }
        if (overallJavaCount == 0) {
            throw new RuntimeException("No Java rules found - start this script from the languagetool-standalone directory");
        }
        System.out.println("</tbody>");
        System.out.println("</table>");
    }

    private int countRulesForLanguage(Language lang) throws IOException {
        List ruleFileNames = lang.getRuleFileNames();
        int count = 0;
        for (String ruleFileName : ruleFileNames) {
            URL url = this.getClass().getResource(ruleFileName);
            if (url == null) continue;
            String xmlRules = StringTools.readStream((InputStream)Tools.getStream((String)ruleFileName), (String)"utf-8");
            xmlRules = xmlRules.replaceAll("(?s)<!--.*?-->", "");
            xmlRules = xmlRules.replaceAll("(?s)<rules.*?>", "");
            count += this.countXmlRules(xmlRules);
            count += this.countXmlRuleGroupRules(xmlRules);
        }
        return count;
    }

    private List<String> getVariantNames(List<Language> allLanguages, Language lang) {
        List<Language> variants = this.getVariants(allLanguages, lang);
        ArrayList<String> result = new ArrayList<String>();
        for (Language l : variants) {
            result.add(l.getName().replaceAll(".*\\((.*?)\\).*", "$1").trim());
        }
        return result;
    }

    private List<Language> getVariants(List<Language> allLanguages, Language lang) {
        ArrayList<Language> variants = new ArrayList<Language>();
        for (Language sortedLanguage : allLanguages) {
            if (!sortedLanguage.isVariant() || !lang.getShortCode().equals(sortedLanguage.getShortCode())) continue;
            variants.add(sortedLanguage);
        }
        return variants;
    }

    private List<Language> getSortedLanguages() {
        ArrayList<Language> sortedLanguages = new ArrayList<Language>(Languages.get());
        sortedLanguages.sort(Comparator.comparing(Language::getName));
        return sortedLanguages;
    }

    private int countXmlRules(String xmlRules) {
        return StringUtils.countMatches((CharSequence)xmlRules, (CharSequence)"<rule ");
    }

    private int countXmlRuleGroupRules(String xmlRules) {
        return StringUtils.countMatches((CharSequence)xmlRules, (CharSequence)"<rule>");
    }

    private SpellcheckSupport spellcheckSupport(Language lang, List<Language> allLanguages) throws IOException {
        if (this.spellcheckSupport(lang) != SpellcheckSupport.None) {
            return this.spellcheckSupport(lang);
        }
        List<Language> variants = this.getVariants(allLanguages, lang);
        for (Language variant : variants) {
            if (this.spellcheckSupport(variant) == SpellcheckSupport.None) continue;
            return this.spellcheckSupport(variant);
        }
        return SpellcheckSupport.None;
    }

    private SpellcheckSupport spellcheckSupport(Language lang) throws IOException {
        ArrayList rules = new ArrayList(lang.getRelevantRules(JLanguageTool.getMessageBundle(), null, null, Collections.emptyList()));
        rules.addAll(lang.getRelevantLanguageModelCapableRules(JLanguageTool.getMessageBundle(), null, null, null, null, Collections.emptyList()));
        for (Rule rule : rules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            if (rule instanceof HunspellNoSuggestionRule) {
                return SpellcheckSupport.NoSuggestion;
            }
            return SpellcheckSupport.Full;
        }
        return SpellcheckSupport.None;
    }

    private int countConfusionPairs(Language lang) {
        String path = "/" + lang.getShortCode() + "/confusion_sets.txt";
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        if (dataBroker.resourceExists(path)) {
            int n;
            block9: {
                InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(path);
                try {
                    ConfusionSetLoader confusionSetLoader = new ConfusionSetLoader((Language)AmericanEnglish.getInstance());
                    n = confusionSetLoader.loadConfusionPairs(confusionSetStream).size() / 2;
                    if (confusionSetStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (confusionSetStream != null) {
                            try {
                                confusionSetStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                confusionSetStream.close();
            }
            return n;
        }
        return 0;
    }

    private String getMaintainerInfo(Language lang) {
        StringBuilder maintainerInfo = new StringBuilder();
        if (lang.getMaintainers() != null) {
            for (Contributor contributor : lang.getMaintainers()) {
                if (!StringTools.isEmpty((String)maintainerInfo.toString())) {
                    maintainerInfo.append(", ");
                }
                if (contributor.getUrl() != null) {
                    maintainerInfo.append("<a href=\"");
                    maintainerInfo.append(contributor.getUrl());
                    maintainerInfo.append("\">");
                }
                maintainerInfo.append(contributor.getName());
                if (contributor.getUrl() == null) continue;
                maintainerInfo.append("</a>");
            }
        }
        return maintainerInfo.toString();
    }

    private static class JavaFilter
    implements FileFilter {
        private final String langName;

        JavaFilter(String langName) {
            this.langName = langName;
        }

        @Override
        public boolean accept(File f) {
            String filename = f.getName();
            boolean isAbstractTopClass = filename.endsWith(this.langName + "Rule.java");
            boolean isSpellerClass = filename.endsWith("SpellerRule.java");
            return filename.endsWith(".java") && !isAbstractTopClass && !isSpellerClass;
        }
    }

    static enum SpellcheckSupport {
        Full,
        NoSuggestion,
        None;

    }
}

