/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.languagetool.rules.de.LineExpander;

public class ProhibitComparator {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + ProhibitComparator.class.getName() + " <oldFile> <newFile>");
            System.exit(1);
        }
        List<String> expanded1 = ProhibitComparator.getExpandedLines(args[0]);
        List<String> expanded2 = ProhibitComparator.getExpandedLines(args[1]);
        System.out.println("Words removed in " + args[1] + ":");
        System.out.println("*** NOTE: result might not be accurate for words with '.*'");
        for (String word : expanded1) {
            if (expanded2.contains(word) || ProhibitComparator.hasPrefixLine(word, expanded2)) continue;
            System.out.println(word);
        }
    }

    private static boolean hasPrefixLine(String word, List<String> expanded2) {
        for (String line : expanded2) {
            if (!line.endsWith(".*") || !word.startsWith(line.substring(0, line.length() - 2))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<String> getExpandedLines(String filename) throws IOException {
        LineExpander expander = new LineExpander();
        List<String> lines = Files.readAllLines(Paths.get(filename, new String[0]));
        ArrayList<String> expanded = new ArrayList<String>();
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            expanded.addAll(expander.expandLine(line));
        }
        return expanded;
    }
}

