/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class NoSuggestionRuleList {
    private static final String POPULARITY_FILE = "/home/dnaber/Downloads/rule_matches_nl_1w_detailed.csv";

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: " + NoSuggestionRuleList.class.getSimpleName() + " <langCodes>");
            System.exit(1);
        }
        HashMap<String, Float> popularity = new HashMap<String, Float>();
        if (POPULARITY_FILE != null) {
            List<String> lines = Files.readAllLines(Paths.get(POPULARITY_FILE, new String[0]));
            for (String line : lines) {
                String[] parts = line.split(",");
                try {
                    popularity.put(parts[0], Float.valueOf(Float.parseFloat(parts[1])));
                }
                catch (NumberFormatException e) {
                    System.err.println("Ignoring line: " + line + ", " + e.getMessage());
                }
            }
        }
        System.out.println("Loaded " + popularity.size() + " popularity mappings");
        for (String langCode : args) {
            Language lang = Languages.getLanguageForShortCode((String)langCode);
            JLanguageTool lt = new JLanguageTool(lang);
            for (Rule rule : lt.getAllActiveRules()) {
                lt.disableRule(rule.getId());
            }
            int suggestion = 0;
            int noSuggestion = 0;
            for (Rule rule : lt.getAllRules()) {
                List incorrectExamples;
                if (rule.isDefaultOff() || (incorrectExamples = rule.getIncorrectExamples()).isEmpty()) continue;
                String incorrectExample = ((IncorrectExample)incorrectExamples.get(0)).getExample().replace("<marker>", "").replace("</marker>", "");
                lt.enableRule(rule.getId());
                List matches = lt.check(incorrectExample);
                Iterator iterator = matches.iterator();
                if (iterator.hasNext()) {
                    RuleMatch match = (RuleMatch)iterator.next();
                    if (match.getSuggestedReplacements().isEmpty()) {
                        NoSuggestionRuleList.printRule(rule.getId(), rule, incorrectExample, popularity);
                        ++noSuggestion;
                    } else {
                        ++suggestion;
                    }
                }
                lt.disableRule(rule.getId());
            }
            System.out.println(lang + ":");
            System.out.printf("With suggestion   : %d\n", suggestion);
            System.out.printf("Without suggestion: %d (%.2f%%)\n", noSuggestion, (double)((float)noSuggestion / (float)(suggestion + noSuggestion)) * 100.0);
            System.out.println();
        }
    }

    private static void printRule(String id, Rule rule, String incorrectExample, Map<String, Float> popularity) {
        Float pop = popularity.get(rule.getId());
        if (pop != null) {
            System.out.printf(Locale.ENGLISH, "%.4f " + id + "\n", pop);
        } else {
            System.out.println("0 " + id);
        }
    }
}

