/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.languagetool.language.identifier.detector.NGramDetector;

public class NGramLangIdentifierPerformanceTest {
    private static final File ngramZip = new File("/home/languagetool/ngram-lang-id/model_ml50_new.zip");
    private static final Path input = Paths.get("/home/dnaber/data/corpus/tatoeba/20191014/sentences_shuf.txt", new String[0]);
    private static final int limit = 10000;

    public void testPerformance() throws IOException {
        System.out.println("Loading ngrams...");
        NGramDetector ngram = new NGramDetector(ngramZip, 50);
        System.out.println("Loaded.");
        int i = 0;
        double totalMillis = 0.0;
        long totalLength = 0L;
        long totalRuns = 0L;
        System.out.println("Loading input...");
        List<String> lines = Files.readAllLines(input);
        System.out.println("Loaded " + lines.size() + " lines.");
        for (String line : lines) {
            long startTime = System.nanoTime();
            Map detectLanguages = ngram.detectLanguages(line, null);
            long endTime = System.nanoTime();
            double runTimeMillis = (float)(endTime - startTime) / 1000.0f / 1000.0f;
            if (i > 10) {
                totalMillis += runTimeMillis;
                totalLength += (long)line.length();
                ++totalRuns;
                if (runTimeMillis > 5.0) {
                    System.out.println(line.length() + " chars took " + runTimeMillis + "ms for text: " + line);
                }
            } else {
                System.out.println("Skipping early run " + i);
            }
            if (i > 10000) {
                System.out.println("Stopping test at limit 10000");
                break;
            }
            ++i;
        }
        System.out.println("Runs: " + totalRuns);
        System.out.printf(Locale.ENGLISH, "Avg. length: %.2f chars\n", (double)totalLength / (double)totalRuns);
        System.out.printf(Locale.ENGLISH, "Avg: %.2fms\n", totalMillis / (double)totalRuns);
    }

    public static void main(String[] args) throws IOException {
        new NGramLangIdentifierPerformanceTest().testPerformance();
    }
}

