/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.JLanguageTool;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.de.GermanSpellerRule;
import org.languagetool.tools.StringTools;

public class MissingGermanCompoundsFinder {
    private final GermanSpellerRule germanSpeller = new GermanSpellerRule(JLanguageTool.getMessageBundle(), GermanyGerman.getInstance());

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + MissingGermanCompoundsFinder.class.getSimpleName() + " <filename>");
            System.exit(1);
        }
        String filename = args[0];
        new MissingGermanCompoundsFinder().run(filename);
    }

    private void run(String filename) throws IOException {
        String line;
        System.out.println("# compound words not accepted by LT speller");
        BufferedReader reader = this.getReaderForFilename(filename);
        GermanWordSplitter splitter = new GermanWordSplitter(false);
        HashMap<String, Integer> firstPartCount = new HashMap<String, Integer>();
        while ((line = reader.readLine()) != null) {
            List wordParts;
            String word;
            int count;
            if (line.contains("\t")) {
                count = Integer.parseInt(line.split("\t")[0]);
                word = line.split("\t")[1];
            } else {
                count = 1;
                word = line;
            }
            if (word.length() >= 50 || !StringTools.startsWithUppercase((String)word) || this.isKnownByGermanSpeller(word) || (wordParts = splitter.splitWord(word)).size() <= 1) continue;
            String key = (String)wordParts.get(0);
            if (firstPartCount.containsKey(key)) {
                firstPartCount.put(key, (Integer)firstPartCount.get(key) + count);
                continue;
            }
            firstPartCount.put(key, count);
        }
        for (Map.Entry entry : firstPartCount.entrySet()) {
            if ((Integer)entry.getValue() > 0) {
                boolean known = this.isKnownByGermanSpeller((String)entry.getKey() + "test");
                System.out.println(entry.getValue() + " " + (String)entry.getKey() + " " + known);
                continue;
            }
            System.out.println(entry.getValue() + " " + (String)entry.getKey());
        }
    }

    private boolean isKnownByGermanSpeller(String word) {
        return !this.germanSpeller.isMisspelled(StringTools.uppercaseFirstChar((String)word)) || !this.germanSpeller.isMisspelled(StringTools.lowercaseFirstChar((String)word));
    }

    private BufferedReader getReaderForFilename(String filename) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
        return new BufferedReader(isr);
    }
}

