/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.tagging.en.EnglishTagger;

public class MissingEnglishPosFinder {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + MissingEnglishPosFinder.class.getSimpleName() + " <file> <ngram_dir>");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
        LuceneLanguageModel lm = new LuceneLanguageModel(new File(args[1]));
        EnglishTagger tagger = new EnglishTagger();
        for (String word : lines) {
            int origCount = -1;
            if (word.matches("\\d+ .*")) {
                String[] parts = word.split(" ");
                origCount = Integer.parseInt(parts[0]);
                word = parts[1];
            }
            if ((word = word.trim()).endsWith(".")) {
                word = word.substring(0, word.length() - 1);
            }
            List matches = tagger.tag(Collections.singletonList(word));
            List lcMatches = tagger.tag(Collections.singletonList(word.toLowerCase()));
            if (matches.size() != 1 || !MissingEnglishPosFinder.noTag((AnalyzedTokenReadings)matches.get(0)) || lcMatches.size() != 1 || !MissingEnglishPosFinder.noTag((AnalyzedTokenReadings)lcMatches.get(0))) continue;
            long count = origCount == -1 ? lm.getCount(word) : (long)origCount;
            System.out.println(count + "\t" + word);
        }
    }

    private static boolean noTag(AnalyzedTokenReadings atr) {
        return !atr.isTagged();
    }
}

