/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.language.German;
import org.languagetool.language.GermanyGerman;
import org.languagetool.synthesis.Synthesizer;

public class GermanOldSpellingFinder {
    public static void main(String[] args) throws IOException {
        German lang = GermanyGerman.getInstance();
        Synthesizer synth = lang.getSynthesizer();
        List<String> words = Files.readAllLines(Paths.get(args[0], new String[0]));
        int i = 0;
        for (String word : words) {
            if (i++ % 1000 == 0) {
                System.out.println(i + "...");
            }
            if (!word.matches("^[a-z\u00f6\u00e4\u00fc].*")) continue;
            String[] formsAr = synth.synthesize(new AnalyzedToken(word, "FAKE", word), ".*", true);
            List<String> forms = Arrays.asList(formsAr);
            for (String form : forms) {
                if (!form.matches(".*o\u00df") || forms.contains(StringUtils.replaceOnce((String)form, (String)"\u00df", (String)"ss"))) continue;
                System.out.println("No 'ss' form found: " + form);
            }
        }
    }

    public static void main2(String[] args) throws IOException {
        German lang = GermanyGerman.getInstance();
        Synthesizer synth = lang.getSynthesizer();
        String tmpWord = "hintergie\u00dfen";
        Object[] formsAr = synth.synthesize(new AnalyzedToken(tmpWord, "FAKE", tmpWord), ".*", true);
        System.out.println(Arrays.toString(formsAr));
        System.exit(1);
    }
}

