/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.Rule;
import org.languagetool.rules.de.GermanSpellerRule;

public class GenderWordFinder {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + GenderWordFinder.class.getSimpleName() + " <file>");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
        HashSet<String> candidates = new HashSet<String>();
        for (String line : lines) {
            if (!line.endsWith("e")) continue;
            candidates.add(line);
        }
        German de = GermanyGerman.getInstance();
        JLanguageTool lt = new JLanguageTool((Language)de);
        for (Rule rule : lt.getAllActiveRules()) {
            if (rule.getId().equals("GERMAN_SPELLER_RULE")) continue;
            lt.disableRule(rule.getId());
        }
        GermanSpellerRule speller = new GermanSpellerRule(JLanguageTool.getMessageBundle(), de);
        for (String line : lines) {
            if (!line.endsWith("innen") || !candidates.contains(line.replace("innen", "e")) || !speller.isMisspelled(line.replace("innen", "")) || lt.check(line.replace("innen", "*innen")).size() <= 0) continue;
            System.out.println(line.replace("innen", "*innen"));
        }
    }
}

