/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.util.Random;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.chunking.Chunker;
import org.languagetool.dev.Fuzzer;

public class FuzzerForAnalysis
extends Fuzzer {
    private void run() throws IOException {
        for (int i = 0; i < 10; ++i) {
            System.out.println("-----------------------");
            Random rnd = new Random(i);
            for (Language language : Languages.get()) {
                JLanguageTool lt = new JLanguageTool(language);
                Chunker chunker = language.getChunker();
                if (chunker == null) continue;
                String text = this.fuzz(rnd, 2500);
                long t1 = System.currentTimeMillis();
                System.out.println(language.getShortCode() + " with text length of " + text.length() + "...");
                lt.getAnalyzedSentence(text);
                long t2 = System.currentTimeMillis();
                long runtime = t2 - t1;
                float relRuntime = (float)runtime / (float)text.length() * 1000.0f;
                System.out.printf(language.getShortCode() + ": " + runtime + "ms = %.2f ms/1K chars\n", Float.valueOf(relRuntime));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        new FuzzerForAnalysis().run();
    }
}

