/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;

public class Fuzzer {
    private static final String[] charList = "0,.-".split("");

    private void run() throws IOException {
        Random rnd = new Random(231L);
        for (Language language : Languages.get()) {
            JLanguageTool lt = new JLanguageTool(language);
            String text = this.fuzz(rnd, 1000);
            long t1 = System.currentTimeMillis();
            System.out.println(language.getShortCode() + " with text length of " + text.length() + "...");
            System.out.println(">> " + text);
            lt.check(text);
            long t2 = System.currentTimeMillis();
            System.out.println(language.getShortCode() + ": " + (t2 - t1) + "ms");
        }
    }

    String fuzz(Random rnd, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < charList.length; ++i) {
            int randomPos = rnd.nextInt(charList.length);
            int repeat = rnd.nextInt(length);
            String s = StringUtils.repeat((String)charList[randomPos], (int)repeat);
            sb.append(s);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        new Fuzzer().run();
    }
}

