/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;

final class ExampleSentencePrinter {
    private static final int MAX_BLOCK_SIZE = 5000;

    ExampleSentencePrinter() {
    }

    private void run(Language lang) {
        File basePath = new File("/home/dnaber/lt/git/languagetool/languagetool-language-modules");
        if (!basePath.exists()) {
            throw new RuntimeException("basePath does not exist: " + basePath);
        }
        JLanguageTool tool = new JLanguageTool(lang);
        System.out.println("<html>");
        System.out.println("<head>");
        System.out.println("  <title>LanguageTool examples sentences</title>");
        System.out.println("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        System.out.println("</head>");
        System.out.println("<body>");
        int i = 1;
        int blockSize = 0;
        for (Rule rule : tool.getAllActiveRules()) {
            List incorrectExamples = rule.getIncorrectExamples();
            if (incorrectExamples.size() <= 0) continue;
            String example = ((IncorrectExample)incorrectExamples.get(0)).getExample().replace("<marker>", "<b>").replace("</marker>", "</b>");
            int exampleLength = example.replace("<b>", "").replace("</b>", "").length();
            if (blockSize + exampleLength > 5000) {
                System.out.println("<br><br>");
                blockSize = 0;
            }
            System.out.println(example + "<br>");
            blockSize += exampleLength;
            ++i;
        }
        System.out.println("</body>");
        System.out.println("</html>");
    }

    public static void main(String[] args) {
        ExampleSentencePrinter prg = new ExampleSentencePrinter();
        prg.run(Languages.getLanguageForShortCode((String)"de"));
    }
}

