/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;

public class DutchWordSplitter {
    public static void main(String[] args) throws IOException {
        String filename = "/home/dnaber/lt/dictionary-nl.dump";
        MorfologikMultiSpeller speller = new MorfologikMultiSpeller("/nl/spelling/nl_NL.dict", Collections.singletonList("/nl/spelling/spelling.txt"), null, null, 1, null);
        List<String> lines = Files.readAllLines(Paths.get(filename, new String[0]));
        int lineCount = 0;
        long lineTime = System.currentTimeMillis();
        for (String line : lines) {
            if (!speller.isMisspelled(line)) {
                for (int i = 1; i < line.length(); ++i) {
                    String part1 = line.substring(0, i);
                    String part2 = line.substring(i);
                    if (speller.isMisspelled(part1) || speller.isMisspelled(part2)) continue;
                    System.out.println(line + " => " + part1 + " " + part2);
                }
            }
            if (++lineCount % 1000 != 0) continue;
            long runTime = System.currentTimeMillis() - lineTime;
            lineTime = System.currentTimeMillis();
            System.out.printf("lineCount: " + lineCount + " (%.2fs)\n", Float.valueOf((float)runTime / 1000.0f));
        }
    }
}

