/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.LanguageWithModel;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.zh.ChineseConfusionProbabilityRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.zh.ChineseTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.zh.ChineseSentenceTokenizer;
import org.languagetool.tokenizers.zh.ChineseWordTokenizer;

public class Chinese
extends LanguageWithModel {
    private static final String LANGUAGE_SHORT_CODE = "zh-CN";
    private static volatile Throwable instantiationTrace;

    public Chinese() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected Chinese(boolean fakeValue) {
    }

    public String getShortCode() {
        return "zh";
    }

    public String getName() {
        return "Chinese";
    }

    public String[] getCountries() {
        return new String[]{"CN"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Tao Lin")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) {
        return Arrays.asList(new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this));
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new ChineseTagger();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new ChineseWordTokenizer();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new ChineseSentenceTokenizer();
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Collections.singletonList(new ChineseConfusionProbabilityRule(messages, languageModel, (Language)this));
    }

    @NotNull
    public static Chinese getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof Chinese) {
            Chinese chinese = (Chinese)language;
            return chinese;
        }
        throw new RuntimeException("Chinese language expected, got " + language);
    }
}

