/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.PosTagHelper;

public class MissingHyphenRule
extends Rule {
    private static final String UA_1992_TAG_PART = ":up92";
    private static final Map<String, String> dashPrefixes = ExtraDictionaryLoader.loadMap("/uk/dash_prefixes.txt");
    private static final Pattern ALL_LOWER = Pattern.compile("[\u0430-\u044f\u0456\u0457\u0454\u0491'-]+");
    private WordTagger wordTagger;

    public MissingHyphenRule(ResourceBundle messages, WordTagger wordTagger) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.wordTagger = wordTagger;
    }

    public final String getId() {
        return "UK_MISSING_HYPHEN";
    }

    public String getDescription() {
        return "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u0439 \u0434\u0435\u0444\u0456\u0441";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length - 1; ++i) {
            String tokenToCheck;
            String message;
            String suggested;
            boolean isCapitalized;
            String extraTag;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            AnalyzedTokenReadings nextTokenReadings = tokens[i + 1];
            if (!PosTagHelper.hasPosTagStart(nextTokenReadings, "noun") || PosTagHelper.hasPosTagPart(nextTokenReadings, "pron") || !ALL_LOWER.matcher(nextTokenReadings.getCleanToken()).matches() || (extraTag = this.getPrefixExtraTag(tokenReadings, isCapitalized = LemmaHelper.isCapitalized(tokenReadings.getCleanToken()))) == null && (!tokenReadings.getCleanToken().toLowerCase().equals("\u0442\u0430\u0439\u043c") || !LemmaHelper.hasLemma(nextTokenReadings, "\u0430\u0443\u0442")) || "\u043c\u0435\u0434\u0456\u0430".equalsIgnoreCase(tokenReadings.getCleanToken()) && nextTokenReadings.getCleanToken().matches("\u043a\u0440\u0430\u0457\u043d\u0438|\u043f\u0456\u0432\u043e\u0441\u0442\u0440\u043e\u0432\u0430") || "\u0448\u043e\u0443".equalsIgnoreCase(tokenReadings.getCleanToken()) && nextTokenReadings.getCleanToken().contains("-")) continue;
            if (UA_1992_TAG_PART.equals(extraTag)) {
                suggested = String.format("%s%s", tokenReadings.getToken(), nextTokenReadings.getToken());
                message = "\u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0437\u0430\u0439\u0432\u0438\u0439 \u043f\u0440\u043e\u0431\u0456\u043b?";
            } else {
                suggested = String.format("%s-%s", tokenReadings.getToken(), nextTokenReadings.getToken());
                message = "\u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043e \u0434\u0435\u0444\u0456\u0441?";
            }
            String string = tokenToCheck = isCapitalized ? StringUtils.uncapitalize((String)suggested) : suggested;
            if (this.wordTagger.tag(tokenToCheck).size() <= 0 && (!UA_1992_TAG_PART.equals(extraTag) || !PosTagHelper.hasPosTagPart(nextTokenReadings, UA_1992_TAG_PART))) continue;
            RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), nextTokenReadings.getEndPos(), message, this.getDescription());
            potentialRuleMatch.setSuggestedReplacement(suggested);
            ruleMatches.add(potentialRuleMatch);
        }
        return ruleMatches.toArray(RuleMatch.EMPTY_ARRAY);
    }

    private String getPrefixExtraTag(AnalyzedTokenReadings tokenReadings, boolean isCapitalized) {
        String token = tokenReadings.getToken();
        if (isCapitalized) {
            token = StringUtils.uncapitalize((String)token);
        }
        return dashPrefixes.get(token);
    }

    static {
        dashPrefixes.remove("\u0431\u043b\u043e\u043a");
        dashPrefixes.remove("\u0440\u0435\u0439\u0442\u0438\u043d\u0433");
        dashPrefixes.entrySet().removeIf(entry -> !ALL_LOWER.matcher((CharSequence)entry.getKey()).matches() || ((String)entry.getValue()).contains(":bad"));
    }
}

