/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.JLanguageTool;

public class ExtraDictionaryLoader {
    public static Set<String> loadSet(String path) {
        HashSet<String> result = new HashSet<String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            result.add(line);
        }
        return result;
    }

    public static Map<String, String> loadMap(String path) {
        Set<String> set = ExtraDictionaryLoader.loadSet(path);
        return set.stream().map(str -> str.trim().split(" ")).collect(Collectors.toMap(x -> x[0], x -> ((String[])x).length > 1 ? x[1] : ""));
    }

    public static Map<String, List<String>> loadSpacedLists(String path) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            line = line.replaceFirst("#.*", "").trim();
            String[] split = line.split(" |\\|");
            List<String> list = Arrays.asList(split).subList(1, split.length);
            result.put(split[0], list);
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, List<String>> loadLists(String path) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try (InputStream is = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);){
            Scanner scanner = new Scanner(is, "UTF-8");
            try {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    String[] split = line.split(" *= *|\\|");
                    List<String> list = Arrays.asList(split).subList(1, split.length);
                    result.put(split[0], list);
                }
                HashMap<String, List<String>> hashMap = result;
                scanner.close();
                return hashMap;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

