/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.RuleException;
import org.languagetool.rules.uk.SearchHelper;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAgreementPrepNounExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementPrepNounExceptionHelper.class);
    private static final Set<String> NAMES = new HashSet<String>(Arrays.asList("\u0456\u043c'\u044f", "\u043f\u0440\u0456\u0437\u0432\u0438\u0449\u0435"));

    public static RuleException getExceptionInfl(AnalyzedTokenReadings[] tokens, int i, TokenAgreementPrepNounRule.State state) {
        AnalyzedTokenReadings tokenReadings = tokens[i];
        String token = tokenReadings.getCleanToken();
        String tokenLower = token.toLowerCase();
        String prep = state.prepTokenReadings.getCleanToken().toLowerCase();
        if (tokenReadings.getToken().equals("\u0434\u0438\u0432\u043e\u043c")) {
            return new RuleException(0);
        }
        if (i < tokens.length - 1 && tokenReadings.getToken().equals("\u0442\u0438\u0441\u044f\u0447\u0430") && (PosTagHelper.hasPosTagPart(tokens[i + 1], "numr") || LemmaHelper.hasLemma(tokens[i + 1], "\u044f\u043a\u0438\u0439\u0441\u044c"))) {
            return new RuleException(0);
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokenReadings, "numr") && PosTagHelper.hasPosTagPart(tokenReadings, "v_naz") && PosTagHelper.hasPosTagPart(tokens[i + 1], "numr") && PosTagHelper.hasPosTag(tokenReadings, Pattern.compile(".*v_(rod|dav|zna|oru|mis).*"))) {
            return new RuleException(1);
        }
        if (prep.equals("\u043d\u0430")) {
            if (LemmaHelper.isCapitalized(token) && PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("noun.*?:.:v_rod.*"))) {
                return new RuleException(RuleException.Type.exception);
            }
            if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("noun:anim:.:v_naz:prop:[fl]name.*")) && (i > 1 && NAMES.contains(tokens[i - 2].getAnalyzedToken(0).getToken()) || i > 2 && NAMES.contains(tokens[i - 3].getAnalyzedToken(0).getLemma()))) {
                return new RuleException(RuleException.Type.exception);
            }
            if (tokenLower.matches("\u0442\u0438|\u0432\u0438")) {
                return new RuleException(RuleException.Type.exception);
            }
            if (i < tokens.length - 1 && token.equals("\u041f\u0456\u043f") && tokens[i + 1].getCleanToken().equals("\u0406\u0432\u0430\u043d")) {
                return new RuleException(RuleException.Type.exception);
            }
            if (tokenLower.equals("\u043c\u0430\u043d\u0435\u0440")) {
                return new RuleException(RuleException.Type.exception);
            }
        }
        if (state.prepPos > 1 && prep.equals("\u0437\u0430\u0440\u0430\u0434\u0438") && tokens[state.prepPos - 1].getCleanToken().matches("(?iu)\u0441\u043f\u0440\u0430\u0432\u0435\u0434\u043b\u0438\u0432\u043e\u0441\u0442\u0456|\u043e\u0431.\u0454\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0456")) {
            return new RuleException(RuleException.Type.exception);
        }
        if (prep.equals("\u043f\u0440\u0438")) {
            if (token.equals("\u0457\u0445")) {
                return new RuleException(RuleException.Type.skip);
            }
        } else if (prep.equals("\u0437") ? token.equals("\u0440\u0430\u043d\u0430") : (prep.equals("\u0432\u0456\u0434") ? token.equalsIgnoreCase("\u0430") || token.equals("\u0440\u0430\u043d\u0430") || token.equals("\u043a\u043e\u0440\u043a\u0438") || token.equals("\u043c\u0430\u043b\u0430") : prep.equals("\u0434\u043e") && (token.equalsIgnoreCase("\u044f") || token.equals("\u043a\u043e\u0440\u043a\u0438") || token.equals("\u0432\u0435\u043b\u0438\u043a\u0430")))) {
            return new RuleException(RuleException.Type.exception);
        }
        if (tokens.length > i + 1) {
            if ((PosTagHelper.hasPosTagStart(tokens[i + 1], "num") || tokens[i + 1].getToken().equals("$")) && LemmaHelper.PLUS_MINUS.contains(tokenLower)) {
                return new RuleException(RuleException.Type.exception);
            }
            if (PosTagHelper.hasPosTag(tokenReadings, "noun.*?:v_oru.*") && tokens[i + 1].hasPartialPosTag("adjp:pasv")) {
                return new RuleException(1);
            }
            if (token.equals("\u0441\u0432\u044f\u0442\u0430\u044f") && tokens[i + 1].getToken().equals("\u0441\u0432\u044f\u0442\u0438\u0445")) {
                return new RuleException(RuleException.Type.exception);
            }
            if ((prep.equals("\u0447\u0435\u0440\u0435\u0437") || prep.equals("\u043d\u0430")) && LemmaHelper.hasLemma(tokenReadings, LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun:inanim:p:v_(rod|zna).*")) && (tokens[i + 1].hasPartialPosTag("num") || i < tokens.length - 2 && LemmaHelper.hasLemma(tokens[i + 1], Arrays.asList("\u0437\u043e", "\u0437", "\u0456\u0437")) && tokens[i + 2].hasPartialPosTag("num"))) {
                return new RuleException(RuleException.Type.exception);
            }
            if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("noun.*v_dav:&pron:(refl|pers).*")) && tokens[i + 1].getCleanToken().startsWith("\u043f\u043e\u0434\u0456\u0431\u043d")) {
                return new RuleException(0);
            }
            if ((token.equals("\u0443\u0441\u0456\u043c") || token.equals("\u0432\u0441\u0456\u043c")) && tokens[i + 1].getCleanToken().startsWith("\u0432\u0456\u0434\u043e\u043c")) {
                return new RuleException(0);
            }
            if (prep.equalsIgnoreCase("\u0434\u043e") && token.equals("\u0441\u0445\u0456\u0434") && tokens[i + 1].getCleanToken().equals("\u0441\u043e\u043d\u0446\u044f")) {
                return new RuleException(RuleException.Type.exception);
            }
            if (tokens.length > i + 2) {
                String genders;
                if (PosTagHelper.hasPosTag(tokenReadings, "adj:[mfn]:v_rod.*") && PosTagHelper.hasPosTag(tokens[i + 1], "noun.*?:[" + (genders = PosTagHelper.getGenders(tokenReadings, "adj:[mfn]:v_rod.*")) + "]:v_rod.*")) {
                    ++i;
                    return new RuleException(1);
                }
                if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("noun.*v_(dav|oru):&pron:neg.*")) && tokens[i + 1].getCleanToken().equals("\u043d\u0435")) {
                    return new RuleException(RuleException.Type.skip);
                }
            }
        }
        return new RuleException(RuleException.Type.none);
    }

    public static RuleException getExceptionStrong(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings prepTokenReadings) {
        AnalyzedTokenReadings tokenReadings = tokens[i];
        String token = tokenReadings.getCleanToken();
        String tokenLower = token.toLowerCase();
        String prep = prepTokenReadings.getCleanToken().toLowerCase();
        if ((prep.equals("\u0434\u043e") || prep.equals("\u043f\u043e")) && tokenLower.matches("\u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456|[\u0432\u0443]\u0447\u043e\u0440\u0430|\u043f\u043e\u0437\u0430\u0432\u0447\u043e\u0440\u0430|(\u043f\u0456\u0441\u043b\u044f)?\u0437\u0430\u0432\u0442\u0440\u0430|\u0442\u0435\u043f\u0435\u0440|\u0437\u0430\u0440\u0430\u0437|\u043d\u0438\u043d\u0456|\u043e\u043f\u0456\u0432\u0434\u043d\u044f|\u043e\u043f\u0456\u0432\u043d\u043e\u0447\u0456|\u0434\u043e\u0441\u0456|\u043d\u0430\u0432\u043f\u0430\u043a\u0438")) {
            return new RuleException(RuleException.Type.exception);
        }
        if ((prep.equals("\u043d\u0430") || prep.equals("\u0432\u0456\u0434") || prep.equals("\u043f\u0440\u043e")) && tokenLower.matches("\u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456|[\u0432\u0443]\u0447\u043e\u0440\u0430|\u043f\u043e\u0437\u0430\u0432\u0447\u043e\u0440\u0430|(\u043f\u0456\u0441\u043b\u044f)?\u0437\u0430\u0432\u0442\u0440\u0430|\u0442\u0435\u043f\u0435\u0440|\u0437\u0430\u0440\u0430\u0437|\u043d\u0438\u043d\u0456|\u0442\u043e\u0434\u0456|\u043f\u043e\u0442\u0456\u043c|\u0449\u043e\u0434\u0435\u043d\u044c|\u043f\u043e\u0432\u0441\u044f\u043a\u0434\u0435\u043d\u044c")) {
            return new RuleException(RuleException.Type.exception);
        }
        if (prep.matches("\u0437\u0430|\u0437\u0456?|\u0456\u0437") && tokenLower.matches("\u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456|[\u0432\u0443]\u0447\u043e\u0440\u0430|\u043f\u043e\u0437\u0430\u0432\u0447\u043e\u0440\u0430|(\u043f\u0456\u0441\u043b\u044f)?\u0437\u0430\u0432\u0442\u0440\u0430")) {
            return new RuleException(RuleException.Type.exception);
        }
        if ((prep.equals("\u0432") || prep.equals("\u0443")) && Arrays.asList("\u043d\u0456\u043a\u0443\u0434\u0438").contains(tokenLower)) {
            return new RuleException(RuleException.Type.exception);
        }
        if (i < tokens.length - 1 && token.equals("\u043d\u0435") && PosTagHelper.hasPosTagStart(tokens[i + 1], "ad")) {
            return new RuleException(0);
        }
        if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokenReadings, LemmaHelper.ADV_QUANT_PATTERN, Pattern.compile("adv.*"))) {
            return new RuleException(RuleException.Type.exception);
        }
        if (i < tokens.length - 1 && TokenAgreementPrepNounRule.Z_ZI_IZ.contains(prep) && LemmaHelper.hasLemma(tokens[i], LemmaHelper.PSEUDO_NUM_LEMMAS)) {
            return new RuleException(RuleException.Type.exception);
        }
        if (PosTagHelper.hasPosTagAll(tokenReadings.getReadings(), Pattern.compile("adv(?!p).*"))) {
            if (i < tokens.length - 1 && tokens[i + 1].getCleanToken().equals("\u0441\u043e\u0431\u0456")) {
                return new RuleException(1);
            }
            return new RuleException(0);
        }
        if (prep.equals("\u0437\u0430\u043c\u0456\u0441\u0442\u044c") && new SearchHelper.Match().target(SearchHelper.Condition.postag(Pattern.compile("verb.*:inf.*"))).limit(4).skip(SearchHelper.Condition.token("\u043c\u043e\u0436\u043d\u0430").negate()).mAfter(tokens, i + 1) > 0) {
            return new RuleException(RuleException.Type.exception);
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u0442\u0435").mBefore(tokens, i) > 0) {
            return new RuleException(RuleException.Type.exception);
        }
        return new RuleException(RuleException.Type.none);
    }

    public static RuleException getExceptionNonInfl(AnalyzedTokenReadings[] tokens, int i, TokenAgreementPrepNounRule.State state) {
        AnalyzedTokenReadings tokenReadings = tokens[i];
        String token = tokenReadings.getCleanToken();
        if (PosTagHelper.hasPosTagStart(tokenReadings, "part") && LemmaHelper.PART_INSERT_PATTERN.matcher(token.toLowerCase()).matches()) {
            return new RuleException(0);
        }
        if (token.matches("\u043b\u0438\u0448(\u0435(\u043d\u044c)?)?")) {
            return new RuleException(0);
        }
        if (tokenReadings.getToken().equals("\u043d\u0430\u043f\u0440\u0438\u043a\u043b\u0430\u0434")) {
            return new RuleException(0);
        }
        if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("adv(?!p).*"))) {
            if (i < tokens.length - 1 && PosTagHelper.hasPosTagStart(tokens[i + 1], "adj") && PosTagHelper.hasPosTagPartAll(tokenReadings, "adv")) {
                return new RuleException(0);
            }
            return new RuleException(RuleException.Type.exception);
        }
        if (tokens.length > i + 1 && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("noun:(un)?anim:.:v_dav:&pron.*"))) {
            if (PosTagHelper.hasPosTagStart(tokens[i + 1], "adj") && CaseGovernmentHelper.hasCaseGovernment(tokens[i + 1], "v_dav")) {
                return new RuleException(1);
            }
            if (tokens.length > i + 2 && PosTagHelper.hasPosTagStart(tokens[i + 1], "adv") && PosTagHelper.hasPosTagStart(tokens[i + 2], "adj") && CaseGovernmentHelper.hasCaseGovernment(tokens[i + 2], "v_dav")) {
                return new RuleException(2);
            }
        }
        if (tokens.length > i + 2 && token.equals("\u043d\u0456\u0447\u043e\u0433\u043e") && tokens[i + 1].getToken().equals("\u043d\u0435") && PosTagHelper.hasPosTagStart(tokens[i + 2], "adj")) {
            return new RuleException(1);
        }
        return new RuleException(RuleException.Type.none);
    }

    static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }
}

