/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class TypographyRule
extends Rule {
    private static final Pattern SHORT_DASH_WORD = Pattern.compile("[\u0430-\u044f\u0456\u0457\u0454\u0491']{2,}([\u2013\u2014][\u0430-\u044f\u0456\u0457\u0454\u0491']{2,})+", 66);
    private static final Pattern BAD_LATIN = Pattern.compile("[\u0425\u0406XIV]+[\u2013\u2014][\u0425\u0406XIV]+");

    public TypographyRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
    }

    public final String getId() {
        return "DASH";
    }

    public String getDescription() {
        return "\u041a\u043e\u0440\u043e\u0442\u043a\u0430 \u0440\u0438\u0441\u043a\u0430 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u0434\u0435\u0444\u0456\u0441\u0443";
    }

    public String getShort() {
        return "\u041a\u043e\u0440\u043e\u0442\u043a\u0430 \u0440\u0438\u0441\u043a\u0430";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String shortDashToken = this.shortDashToken(tokens[i]);
            if (shortDashToken == null) continue;
            ArrayList<String> replacements = new ArrayList<String>();
            replacements.add(shortDashToken.replaceAll("[\u2013\u2014]", "-"));
            replacements.add(shortDashToken.replaceAll("[\u2013\u2014]", " \u2014 "));
            String msg = "\u0420\u0438\u0441\u043a\u0430 \u0432\u0441\u0435\u0440\u0435\u0434\u0438\u043d\u0456 \u0441\u043b\u043e\u0432\u0430. \u0412\u0441\u0435\u0440\u0435\u0434\u0438\u043d\u0456 \u0441\u043b\u043e\u0432\u0430 \u0432\u0436\u0438\u0432\u0430\u0439\u0442\u0435 \u0434\u0435\u0444\u0456\u0441, \u043c\u0456\u0436 \u0441\u043b\u043e\u0432\u0430\u043c\u0438 \u0432\u0438\u043e\u043a\u0440\u0435\u043c\u043b\u044e\u0439\u0442\u0435 \u0440\u0438\u0441\u043a\u0443 \u043f\u0440\u043e\u0431\u0456\u043b\u0430\u043c\u0438.";
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokens[i], replacements, msg, sentence);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private String shortDashToken(AnalyzedTokenReadings tokenReadings) {
        List readings = tokenReadings.getReadings();
        if (readings.size() == 0 || tokenReadings.getToken() == null) {
            return null;
        }
        String lastReadingToken = ((AnalyzedToken)readings.get(readings.size() - 1)).getToken();
        return lastReadingToken != null && (lastReadingToken.indexOf(8211) > 0 || lastReadingToken.indexOf(8212) > 0) && SHORT_DASH_WORD.matcher(lastReadingToken).matches() && !BAD_LATIN.matcher(lastReadingToken).matches() ? lastReadingToken : null;
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings readings, List<String> replacements, String msg, AnalyzedSentence sentence) {
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, readings.getStartPos(), readings.getEndPos(), msg, this.getShort());
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }
}

