/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.CompoundDebugLogger;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.LetterEndingForNumericHelper;
import org.languagetool.tagging.uk.PosTagHelper;
import org.languagetool.tagging.uk.UkrainianTagger;

class CompoundTagger {
    private static final String TAG_ANIM = ":anim";
    private static final String TAG_INANIM = ":inanim";
    private static final Pattern EXTRA_TAGS = Pattern.compile(":bad");
    private static final Pattern EXTRA_TAGS_DROP = Pattern.compile(":(comp.|np|ns|slang|rare|xp[1-9]|&predic|&insert)");
    private static final Pattern NOUN_SING_V_ROD_REGEX = Pattern.compile("noun.*?:[mfn]:v_rod.*");
    private static final Pattern SING_REGEX_F = Pattern.compile(":[mfn]:");
    private static final Pattern O_ADJ_PATTERN = Pattern.compile(".+?(\u043e|[\u0447\u0448\u0449]\u0435)");
    private static final Pattern NUMR_ADJ_PATTERN = Pattern.compile(".+?(\u043e\u0434\u043d\u043e|\u0434\u0432\u043e|\u043e\u0445|\u0438)");
    private static final Pattern DASH_PREFIX_LAT_PATTERN = Pattern.compile("[a-zA-Z]{3,}|[\u03b1-\u03c9\u0391-\u03a9]");
    private static final Pattern YEAR_NUMBER = Pattern.compile("[12][0-9]{3}");
    private static final Pattern NOUN_PREFIX_NUMBER = Pattern.compile("[0-9]+");
    private static final Pattern NOUN_SUFFIX_NUMBER_LETTER = Pattern.compile("[0-9][0-9\u0410-\u042f\u0406\u0407\u0404\u0490-]*");
    private static final Pattern ADJ_PREFIX_NUMBER = Pattern.compile("[0-9]+(,[0-9]+)?([-\u2013\u2014][0-9]+(,[0-9]+)?)?%?|(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})");
    private static final Pattern REQ_NUM_DVA_PATTERN = Pattern.compile("(\u043c\u0456\u0441\u043d|\u0442\u043e\u043c\u043d\u0438\u043a|\u043f\u043e\u0432\u0435\u0440\u0445\u0456\u0432).{0,4}");
    private static final Pattern REQ_NUM_DESYAT_PATTERN = Pattern.compile("(\u043a\u043b\u0430\u0441\u043d\u0438[\u043a\u0446]|\u0440\u0430\u0443\u043d\u0434\u043e\u0432|\u0442\u043e\u043c\u043d|\u0442\u043e\u043c\u043e\u0432|\u0445\u0432\u0438\u043b\u0438\u043d|\u0434\u0435\u0441\u044f\u0442\u0438\u0440\u0456\u0447|\u043a\u0456\u043b\u043e\u043c\u0435\u0442\u0440\u0456\u0432|\u0440\u0456\u0447).{0,4}");
    private static final Pattern REQ_NUM_STO_PATTERN = Pattern.compile("(\u0440\u0456\u0447\u0447|\u043b\u0456\u0442\u0442|\u043c\u0435\u0442\u0440\u0456\u0432|\u0433\u0440\u0430\u043c\u043e\u0432|\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u043a).{0,3}");
    private static final Pattern INTJ_PATTERN = Pattern.compile("intj.*");
    private static final Pattern MNP_NAZ_REGEX = Pattern.compile(".*?:[mnp]:v_naz.*");
    private static final Pattern MNP_ZNA_REGEX = Pattern.compile(".*?:[mnp]:v_zna.*");
    private static final Pattern MNP_ROD_REGEX = Pattern.compile(".*?:[mnp]:v_rod.*");
    private static final Pattern stdNounTagRegex = Pattern.compile("noun:(?:in)?anim:(.):(v_...).*");
    private static final Set<String> dashPrefixes;
    private static final Set<String> dashPrefixes2;
    private static final Set<String> leftMasterSet;
    private static final Map<String, List<String>> numberedEntities;
    private static final Map<String, Pattern> rightPartsWithLeftTagMap;
    private static final Set<String> slaveSet;
    private static final String ADJ_TAG_FOR_PO_ADV_MIS = "adj:m:v_mis";
    private static final String ADJ_TAG_FOR_PO_ADV_NAZ = "adj:m:v_naz";
    private static final List<String> LEFT_O_ADJ;
    private static final List<String> LEFT_INVALID;
    private static final List<String> LEFT_O_ADJ_INVALID;
    private static final List<String> WORDS_WITH_YEAR;
    private static final List<String> WORDS_WITH_NUM;
    private final WordTagger wordTagger;
    private final Locale conversionLocale;
    private final UkrainianTagger ukrainianTagger;
    private final CompoundDebugLogger compoundDebugLogger = new CompoundDebugLogger();

    CompoundTagger(UkrainianTagger ukrainianTagger, WordTagger wordTagger, Locale conversionLocale) {
        this.ukrainianTagger = ukrainianTagger;
        this.wordTagger = wordTagger;
        this.conversionLocale = conversionLocale;
    }

    @Nullable
    public List<AnalyzedToken> guessCompoundTag(String word) {
        List<AnalyzedToken> guessedCompoundTags = this.doGuessCompoundTag(word);
        this.compoundDebugLogger.logTaggedCompound(guessedCompoundTags);
        return guessedCompoundTags;
    }

    @Nullable
    private List<AnalyzedToken> doGuessCompoundTag(String word) {
        List<AnalyzedToken> tagMatch;
        List<TaggedWord> noDashWordList;
        String noDashWord;
        List<AnalyzedToken> noDashAnalyzedTokens;
        boolean dashPrefixMatch;
        int dashIdx = word.lastIndexOf(45);
        if (dashIdx == word.length() - 1) {
            return null;
        }
        int firstDashIdx = word.indexOf(45);
        if (firstDashIdx == 0) {
            return null;
        }
        boolean startsWithDigit = Character.isDigit(word.charAt(0));
        if (!startsWithDigit && dashIdx != firstDashIdx) {
            List<AnalyzedToken> tokens;
            int dashCount = StringUtils.countMatches((CharSequence)word, (CharSequence)"-");
            if (dashCount >= 2 && dashIdx > firstDashIdx + 1 && (tokens = this.doGuessMultiHyphens(word, firstDashIdx, dashIdx)) != null) {
                return tokens;
            }
            if (dashCount == 2 && dashIdx > firstDashIdx + 1) {
                return this.doGuessTwoHyphens(word, firstDashIdx, dashIdx);
            }
            return null;
        }
        String leftWord = word.substring(0, dashIdx);
        String rightWord = word.substring(dashIdx + 1);
        boolean bl = dashPrefixMatch = dashPrefixes.contains(leftWord) || dashPrefixes.contains(leftWord.toLowerCase()) || DASH_PREFIX_LAT_PATTERN.matcher(leftWord).matches();
        if (!dashPrefixMatch && (startsWithDigit || word.matches("[XLIV]+-.*"))) {
            return this.matchDigitCompound(word, leftWord, rightWord);
        }
        if (Character.isDigit(rightWord.charAt(0))) {
            return this.matchNumberedProperNoun(word, leftWord, rightWord);
        }
        if (LEFT_INVALID.contains(leftWord.toLowerCase())) {
            return null;
        }
        if (leftWord.equalsIgnoreCase("\u043f\u0456\u0432") && Character.isLowerCase(rightWord.charAt(0))) {
            return null;
        }
        List<TaggedWord> leftWdList = this.tagAsIsAndWithLowerCase(leftWord);
        if (rightPartsWithLeftTagMap.containsKey(rightWord)) {
            if (leftWdList.isEmpty()) {
                return null;
            }
            Pattern leftTagRegex = rightPartsWithLeftTagMap.get(rightWord);
            List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(leftAnalyzedTokens.size());
            if (rightWord.equals("\u0442\u043e") && LemmaHelper.hasLemma(leftAnalyzedTokens, Arrays.asList("\u0445\u0442\u043e", "\u0449\u043e", "\u0447\u0438"))) {
                return null;
            }
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                String posTag = analyzedToken.getPOSTag();
                if ((posTag == null || !leftWord.equals("\u0434\u0443\u0436\u0435") || !posTag.contains("adv")) && !leftTagRegex.matcher(posTag).matches()) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, analyzedToken.getLemma()));
            }
            return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
        }
        if (leftWord.equalsIgnoreCase("\u043f\u043e") && rightWord.endsWith("\u0441\u044c\u043a\u0438")) {
            rightWord = rightWord + "\u0439";
        }
        if (Character.isUpperCase(leftWord.charAt(0)) && LemmaHelper.CITY_AVENU.contains(rightWord)) {
            return PosTagHelper.generateTokensForNv(word, "f", ":prop");
        }
        List<TaggedWord> rightWdList = this.tagEitherCase(rightWord);
        if (rightWdList.isEmpty()) {
            Matcher napivMatcher;
            if (word.startsWith("\u043d\u0430\u043f\u0456\u0432") && (napivMatcher = Pattern.compile("\u043d\u0430\u043f\u0456\u0432(.+?)-\u043d\u0430\u043f\u0456\u0432(.+)").matcher(word)).matches()) {
                List<AnalyzedToken> napivRightAnalyzedTokens;
                List<TaggedWord> napivLeftWdList = this.tagAsIsAndWithLowerCase(napivMatcher.group(1));
                List<TaggedWord> napivRightWdList = this.tagAsIsAndWithLowerCase(napivMatcher.group(2));
                List<AnalyzedToken> napivLeftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(napivMatcher.group(1), napivLeftWdList);
                List<AnalyzedToken> tagMatch2 = this.tagMatch(word, napivLeftAnalyzedTokens, napivRightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(napivMatcher.group(2), napivRightWdList));
                if (tagMatch2 != null) {
                    return tagMatch2;
                }
            }
            return null;
        }
        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList);
        if (leftWord.length() == 1 && Character.isUpperCase(leftWord.charAt(0)) && LemmaHelper.hasLemma(rightAnalyzedTokens, Arrays.asList("\u043f\u043e\u0434\u0456\u0431\u043d\u0438\u0439"))) {
            return CompoundTagger.generateTokensWithRighInflected(word, leftWord, rightAnalyzedTokens, IPOSTag.adj.getText());
        }
        if (leftWord.equalsIgnoreCase("\u043f\u043e")) {
            if (rightWord.endsWith("\u043e\u043c\u0443")) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_MIS);
            }
            if (rightWord.endsWith("\u0441\u044c\u043a\u0438\u0439")) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_NAZ);
            }
            return null;
        }
        List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
        if (PosTagHelper.hasPosTagPart(leftAnalyzedTokens, "&pron") && !PosTagHelper.hasPosTagPart(leftAnalyzedTokens, "numr")) {
            return null;
        }
        if (!(leftWord.equalsIgnoreCase(rightWord) || !PosTagHelper.hasPosTag(rightAnalyzedTokens, "(part|conj).*|.*?:&pron.*") || PosTagHelper.hasPosTag(leftAnalyzedTokens, "numr.*") && PosTagHelper.hasPosTag(rightAnalyzedTokens, "numr.*"))) {
            return null;
        }
        if (Character.isUpperCase(rightWord.charAt(0))) {
            if (word.startsWith("\u043f\u0456\u0432-")) {
                ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(rightAnalyzedTokens.size());
                for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                    String rightPosTag = rightAnalyzedToken.getPOSTag();
                    if (rightPosTag == null || !NOUN_SING_V_ROD_REGEX.matcher(rightPosTag).matches()) continue;
                    for (String vid : PosTagHelper.VIDMINKY_MAP.keySet()) {
                        if (vid.equals("v_kly")) continue;
                        String posTag = rightPosTag.replace("v_rod", vid);
                        newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
                    }
                }
                return newAnalyzedTokens;
            }
            return null;
        }
        if (dashPrefixMatch) {
            List<AnalyzedToken> newTokensNoun;
            List<AnalyzedToken> newTokensAdj;
            ArrayList<AnalyzedToken> newTokens = new ArrayList<AnalyzedToken>();
            if (leftWord.length() == 1 && leftWord.matches("[a-zA-Z\u03b1-\u03c9\u0391-\u03a9]") && (newTokensAdj = CompoundTagger.getNvPrefixLatWithAdjMatch(word, rightAnalyzedTokens, leftWord)) != null) {
                newTokens.addAll(newTokensAdj);
            }
            if ((newTokensNoun = CompoundTagger.getNvPrefixNounMatch(word, rightAnalyzedTokens, leftWord)) != null) {
                newTokens.addAll(newTokensNoun);
            }
            return newTokens;
        }
        if (!PosTagHelper.hasPosTag(leftAnalyzedTokens, "intj.*") && !(noDashAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(noDashWord = word.replace("-", ""), noDashWordList = this.tagAsIsAndWithLowerCase(noDashWord))).isEmpty()) {
            return null;
        }
        if (!leftWdList.isEmpty() && leftWord.length() > 2 && (tagMatch = this.tagMatch(word, leftAnalyzedTokens, rightAnalyzedTokens)) != null) {
            return tagMatch;
        }
        List<AnalyzedToken> match = this.tryOWithAdj(word, leftWord, rightAnalyzedTokens);
        if (match != null) {
            return match;
        }
        this.compoundDebugLogger.logUnknownCompound(word);
        return null;
    }

    private List<TaggedWord> tagEitherCase(String rightWord) {
        List rightWdList = this.wordTagger.tag(rightWord);
        if (rightWdList.isEmpty() && Character.isUpperCase(rightWord.charAt(0))) {
            rightWdList = this.wordTagger.tag(rightWord.toLowerCase());
        }
        return rightWdList;
    }

    private List<AnalyzedToken> tryOWithAdj(String word, String leftWord, List<AnalyzedToken> rightAnalyzedTokens) {
        if (leftWord.length() < 3) {
            return null;
        }
        if (LEFT_O_ADJ_INVALID.contains(leftWord.toLowerCase())) {
            return null;
        }
        if (NUMR_ADJ_PATTERN.matcher(leftWord).matches()) {
            return this.numrAdjMatch(word, rightAnalyzedTokens, leftWord);
        }
        if (O_ADJ_PATTERN.matcher(leftWord).matches()) {
            return this.oAdjMatch(word, rightAnalyzedTokens, leftWord);
        }
        return null;
    }

    private List<AnalyzedToken> doGuessMultiHyphens(String word, int firstDashIdx, int dashIdx) {
        String lowerWord = word.toLowerCase();
        String[] parts = lowerWord.split("-");
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(parts));
        if (set.size() == 2) {
            List<TaggedWord> leftWdList = this.tagEitherCase(parts[0]);
            List<TaggedWord> rightWdList = this.tagEitherCase(new ArrayList<String>(set).get(1));
            if (PosTagHelper.hasPosTag2(leftWdList, INTJ_PATTERN) && PosTagHelper.hasPosTag2(rightWdList, INTJ_PATTERN)) {
                return Arrays.asList(new AnalyzedToken(word, rightWdList.get(0).getPosTag(), lowerWord));
            }
        } else if (set.size() == 1) {
            if (lowerWord.equals("\u043b\u0430")) {
                return Arrays.asList(new AnalyzedToken(word, "intj", lowerWord));
            }
            List<TaggedWord> rightWdList = this.tagEitherCase(parts[0]);
            if (PosTagHelper.hasPosTag2(rightWdList, INTJ_PATTERN)) {
                return Arrays.asList(new AnalyzedToken(word, rightWdList.get(0).getPosTag(), lowerWord));
            }
        }
        return null;
    }

    private List<AnalyzedToken> doGuessTwoHyphens(String word, int firstDashIdx, int dashIdx) {
        List<AnalyzedToken> secondAnalyzedTokens;
        List<AnalyzedToken> tagMatchSecondAndThird;
        String[] parts = word.split("-");
        List<TaggedWord> rightWdList = this.tagEitherCase(parts[2]);
        if (rightWdList.isEmpty()) {
            return null;
        }
        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(parts[2], rightWdList);
        String firstAndSecond = parts[0] + "-" + parts[1];
        if (dashPrefixes2.contains(firstAndSecond) || dashPrefixes2.contains(firstAndSecond.toLowerCase())) {
            return CompoundTagger.getNvPrefixNounMatch(word, rightAnalyzedTokens, firstAndSecond);
        }
        List<TaggedWord> secondWdList = this.tagEitherCase(parts[1]);
        if (PosTagHelper.startsWithPosTag(secondWdList, "adj") && (tagMatchSecondAndThird = this.tagMatch(word, secondAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(parts[1], secondWdList), rightAnalyzedTokens)) != null) {
            List<TaggedWord> leftWdList = this.tagEitherCase(parts[0]);
            if (!leftWdList.isEmpty()) {
                List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(parts[0], leftWdList);
                this.tagMatch(word, leftAnalyzedTokens, tagMatchSecondAndThird);
            }
            return tagMatchSecondAndThird;
        }
        List<AnalyzedToken> secondAndThird = this.tryOWithAdj(word, parts[1], rightAnalyzedTokens);
        if (secondAndThird != null) {
            return this.tryOWithAdj(word, parts[0], secondAndThird);
        }
        return null;
    }

    private static List<AnalyzedToken> generateTokensWithRighInflected(String word, String leftWord, List<AnalyzedToken> rightAnalyzedTokens, String posTagStart) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(rightAnalyzedTokens.size());
        for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(posTagStart) || posTag.contains("v_kly")) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens;
    }

    private List<AnalyzedToken> matchNumberedProperNoun(String word, String leftWord, String rightWord) {
        String lemma;
        String posTag;
        ArrayList<AnalyzedToken> newAnalyzedTokens;
        List<AnalyzedToken> leftAnalyzedTokens;
        List<TaggedWord> leftWdList;
        if (NOUN_SUFFIX_NUMBER_LETTER.matcher(rightWord).matches()) {
            LinkedHashSet<AnalyzedToken> newAnalyzedTokens2 = new LinkedHashSet<AnalyzedToken>();
            for (Map.Entry<String, List<String>> entry : numberedEntities.entrySet()) {
                if (!word.matches(entry.getKey())) continue;
                for (String tag : entry.getValue()) {
                    if (tag.contains(":nv")) {
                        String[] tagParts = tag.split(":");
                        String extraTags = tag.replaceFirst(".*?:nv", "").replace(":np", "");
                        List<AnalyzedToken> newTokens = PosTagHelper.generateTokensForNv(word, tagParts[1], extraTags);
                        newAnalyzedTokens2.addAll(newTokens);
                        if (tag.contains(":np") || tag.contains(":p")) continue;
                        newTokens = PosTagHelper.generateTokensForNv(word, "p", extraTags);
                        newAnalyzedTokens2.addAll(newTokens);
                        continue;
                    }
                    newAnalyzedTokens2.add(new AnalyzedToken(word, tag, word));
                }
            }
            if (newAnalyzedTokens2.size() > 0) {
                return new ArrayList<AnalyzedToken>(newAnalyzedTokens2);
            }
        }
        if (YEAR_NUMBER.matcher(rightWord).matches() && !(leftWdList = this.tagAsIsAndWithLowerCase(leftWord)).isEmpty() && Character.isUpperCase(leftWord.charAt(0))) {
            leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            newAnalyzedTokens = new ArrayList<AnalyzedToken>();
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                if (!PosTagHelper.hasPosTagPart(analyzedToken, ":prop") && !WORDS_WITH_YEAR.contains(analyzedToken.getLemma()) || (posTag = analyzedToken.getPOSTag()) == null || !posTag.startsWith("noun:inanim") || posTag.contains("v_kly") || posTag.contains(":p:") && !Arrays.asList("\u0433\u0440\u0430", "\u0432\u0438\u0431\u043e\u0440\u0438", "\u0431\u044e\u0434\u0436\u0435\u0442").contains(analyzedToken.getLemma()) && !posTag.contains(":ns")) continue;
                lemma = analyzedToken.getLemma();
                if (!(posTag = posTag.replace(":geo", "")).contains(":prop")) {
                    posTag = posTag + ":prop";
                    lemma = StringUtils.capitalize((String)lemma);
                }
                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, lemma + "-" + rightWord));
            }
            if (newAnalyzedTokens.size() > 0) {
                return newAnalyzedTokens;
            }
        }
        if (NOUN_PREFIX_NUMBER.matcher(rightWord).matches() && !(leftWdList = this.tagAsIsAndWithLowerCase(leftWord)).isEmpty()) {
            leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            newAnalyzedTokens = new ArrayList();
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                posTag = analyzedToken.getPOSTag();
                lemma = analyzedToken.getLemma();
                if (posTag == null || !posTag.startsWith("noun:inanim") || posTag.contains("v_kly")) continue;
                if (!posTag.contains(":prop") && !WORDS_WITH_NUM.contains(lemma)) {
                    posTag = posTag + ":prop";
                    lemma = StringUtils.capitalize((String)lemma);
                }
                if (!WORDS_WITH_NUM.contains(lemma)) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, lemma + "-" + rightWord));
            }
            if (newAnalyzedTokens.size() > 0) {
                return newAnalyzedTokens;
            }
        }
        return null;
    }

    private List<AnalyzedToken> matchDigitCompound(String word, String leftWord, String rightWord) {
        block11: {
            ArrayList<AnalyzedToken> newAnalyzedTokens;
            block14: {
                List rightWdList;
                block12: {
                    block13: {
                        if (!ADJ_PREFIX_NUMBER.matcher(leftWord).matches()) break block11;
                        newAnalyzedTokens = new ArrayList<AnalyzedToken>();
                        String[] tags = LetterEndingForNumericHelper.findTags(leftWord, rightWord);
                        if (tags == null) break block12;
                        for (String tag : tags) {
                            String lemma = leftWord + "-\u0439";
                            newAnalyzedTokens.add(new AnalyzedToken(word, IPOSTag.adj.getText() + tag + ":&numr", lemma));
                        }
                        if (!"\u043c\u0430".equals(rightWord)) break block13;
                        newAnalyzedTokens.add(new AnalyzedToken(word, IPOSTag.noun.getText() + ":p:v_oru:&numr:bad", leftWord));
                        break block14;
                    }
                    if (!"\u043c\u0438".equals(rightWord) || !Pattern.compile("(.*[^1]|^)[78]").matcher(leftWord).matches()) break block14;
                    newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_rod:bad", leftWord));
                    newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_dav:bad", leftWord));
                    newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_mis:bad", leftWord));
                    break block14;
                }
                if (NOUN_PREFIX_NUMBER.matcher(leftWord).matches()) {
                    String tryPrefix = this.getTryPrefix(rightWord);
                    if (tryPrefix != null) {
                        List rightWdList2 = this.wordTagger.tag(tryPrefix + rightWord);
                        if (rightWdList2 == null) {
                            return null;
                        }
                        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList2);
                        for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
                            String lemma = analyzedToken.getLemma().substring(tryPrefix.length());
                            newAnalyzedTokens.add(new AnalyzedToken(word, analyzedToken.getPOSTag(), leftWord + "-" + lemma));
                        }
                        return newAnalyzedTokens;
                    }
                    if ("\u043c\u043c".equals(rightWord)) {
                        for (String gender : PosTagHelper.BASE_GENDERS) {
                            for (String vidm : PosTagHelper.VIDMINKY_MAP.keySet()) {
                                if (vidm.equals("v_kly")) continue;
                                String posTag = IPOSTag.adj.getText() + ":" + gender + ":" + vidm;
                                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
                            }
                        }
                        return newAnalyzedTokens;
                    }
                    if ("\u0442\u0438".equals(rightWord) && Pattern.compile(".*([0569]|1[0-9])").matcher(leftWord).matches()) {
                        newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_rod:bad", leftWord));
                        newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_dav:bad", leftWord));
                        newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_mis:bad", leftWord));
                    }
                }
                if ((rightWdList = this.wordTagger.tag(rightWord)).isEmpty()) {
                    return null;
                }
                List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList);
                for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
                    if (!analyzedToken.getPOSTag().startsWith(IPOSTag.adj.getText()) && !"\u0432\u0456\u0434\u0441\u043e\u0442\u043a\u043e\u0432\u043e".equals(analyzedToken.getLemma())) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, analyzedToken.getPOSTag(), leftWord + "-" + analyzedToken.getLemma()));
                }
            }
            return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
        }
        return null;
    }

    private String getTryPrefix(String rightWord) {
        if (REQ_NUM_STO_PATTERN.matcher(rightWord).matches()) {
            return "\u0441\u0442\u043e";
        }
        if (REQ_NUM_DESYAT_PATTERN.matcher(rightWord).matches()) {
            return "\u0434\u0435\u0441\u044f\u0442\u0438";
        }
        if (REQ_NUM_DVA_PATTERN.matcher(rightWord).matches()) {
            return "\u0434\u0432\u043e";
        }
        return null;
    }

    @Nullable
    private List<AnalyzedToken> tagMatch(String word, List<AnalyzedToken> leftAnalyzedTokens, List<AnalyzedToken> rightAnalyzedTokens) {
        ArrayList<Object> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
        ArrayList<AnalyzedToken> newAnalyzedTokensAnimInanim = new ArrayList<AnalyzedToken>();
        String animInanimNotTagged = null;
        for (AnalyzedToken leftAnalyzedToken : leftAnalyzedTokens) {
            Matcher matcher;
            String leftPosTag = leftAnalyzedToken.getPOSTag();
            if (leftPosTag == null || IPOSTag.contains(leftPosTag, IPOSTag.abbr.getText()) || leftPosTag.startsWith("noun:inanim") && leftPosTag.contains("v_kly")) continue;
            String leftPosTagExtra = "";
            boolean leftNv = false;
            if (leftPosTag.contains(":nv")) {
                leftNv = true;
                leftPosTag = leftPosTag.replace(":nv", "");
            }
            if ((matcher = EXTRA_TAGS_DROP.matcher(leftPosTag)).find()) {
                leftPosTag = matcher.replaceAll("");
            }
            if ((matcher = EXTRA_TAGS.matcher(leftPosTag)).find()) {
                leftPosTagExtra = leftPosTagExtra + matcher.group();
                leftPosTag = matcher.replaceAll("");
            }
            for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                String leftGenderConj;
                String agreedPosTag;
                Matcher matcherR;
                String rightPosTag = rightAnalyzedToken.getPOSTag();
                if (rightPosTag == null || rightPosTag.contains(IPOSTag.abbr.getText()) || rightPosTag.startsWith("noun:inanim") && rightPosTag.contains("v_kly")) continue;
                String extraNvTag = "";
                boolean rightNv = false;
                if (rightPosTag.contains(":nv")) {
                    rightNv = true;
                    if (leftNv) {
                        extraNvTag = extraNvTag + ":nv";
                    }
                }
                if ((matcherR = EXTRA_TAGS_DROP.matcher(rightPosTag)).find()) {
                    rightPosTag = matcherR.replaceAll("");
                }
                if ((matcherR = EXTRA_TAGS.matcher(rightPosTag)).find()) {
                    rightPosTag = matcherR.replaceAll("");
                }
                if (CompoundTagger.stripPerfImperf(leftPosTag).equals(CompoundTagger.stripPerfImperf(rightPosTag)) && (IPOSTag.startsWith(leftPosTag, IPOSTag.numr, IPOSTag.adv, IPOSTag.adj, IPOSTag.verb) || IPOSTag.startsWith(leftPosTag, IPOSTag.intj) && leftAnalyzedToken.getLemma().equalsIgnoreCase(rightAnalyzedToken.getLemma()))) {
                    String newPosTag = leftPosTag + extraNvTag + leftPosTagExtra;
                    if (leftPosTag.contains("adjp") && !rightPosTag.contains("adjp") || !leftPosTag.contains("adjp") && rightPosTag.contains("adjp")) {
                        newPosTag = newPosTag.replaceFirst(":&adjp:(actv|pasv):(im)?perf", "");
                    }
                    String newLemma = leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma();
                    newAnalyzedTokens.add(new AnalyzedToken(word, newPosTag, newLemma));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.noun.getText()) && rightPosTag.startsWith(IPOSTag.noun.getText())) {
                    if (leftAnalyzedToken.getToken().equalsIgnoreCase(rightAnalyzedToken.getToken()) && leftPosTag.contains(TAG_ANIM) && rightPosTag.contains(TAG_ANIM)) continue;
                    agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv, word);
                    if (agreedPosTag == null && rightPosTag.startsWith("noun:inanim:m:v_naz") && CompoundTagger.isMinMax(rightAnalyzedToken.getToken())) {
                        agreedPosTag = leftPosTag;
                    }
                    if (agreedPosTag == null && !CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
                        agreedPosTag = this.tryAnimInanim(leftPosTag, rightPosTag, leftAnalyzedToken.getLemma(), rightAnalyzedToken.getLemma(), leftNv, rightNv, word);
                        if (agreedPosTag == null) {
                            animInanimNotTagged = leftPosTag.contains(TAG_ANIM) ? "anim-inanim" : "inanim-anim";
                        } else {
                            newAnalyzedTokensAnimInanim.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                            continue;
                        }
                    }
                    if (agreedPosTag == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.numr.getText()) && rightPosTag.startsWith(IPOSTag.numr.getText())) {
                    agreedPosTag = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (IPOSTag.startsWith(leftPosTag, IPOSTag.noun) && IPOSTag.startsWith(rightPosTag, IPOSTag.numr)) {
                    leftGenderConj = PosTagHelper.getGenderConj(leftPosTag);
                    if (leftGenderConj != null && leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) {
                        newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                        if (leftPosTag.contains(":p:")) continue;
                        newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag.replaceAll(":[mfn]:", ":p:") + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                        continue;
                    }
                    String agreedPosTag2 = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag2 == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag2 + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    if (agreedPosTag2.contains(":p:")) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag2.replaceAll(":[mfn]:", ":p:") + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if ((!leftPosTag.startsWith(IPOSTag.noun.getText()) || !IPOSTag.startsWith(rightPosTag, IPOSTag.numr)) && (!IPOSTag.startsWith(rightPosTag, IPOSTag.adj) || !this.isJuniorSenior(leftAnalyzedToken, rightAnalyzedToken)) || (leftGenderConj = PosTagHelper.getGenderConj(leftPosTag)) == null || !leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
            }
        }
        if (!newAnalyzedTokens.isEmpty() && !PosTagHelper.hasPosTagPart(newAnalyzedTokens, ":p:") && (LemmaHelper.hasLemma(leftAnalyzedTokens, LemmaHelper.DAYS_OF_WEEK) && LemmaHelper.hasLemma(rightAnalyzedTokens, LemmaHelper.DAYS_OF_WEEK) || LemmaHelper.hasLemma(leftAnalyzedTokens, LemmaHelper.MONTH_LEMMAS) && LemmaHelper.hasLemma(rightAnalyzedTokens, LemmaHelper.MONTH_LEMMAS))) {
            newAnalyzedTokens.add(new AnalyzedToken(word, ((AnalyzedToken)newAnalyzedTokens.get(0)).getPOSTag().replaceAll(":[mfn]:", ":p:"), ((AnalyzedToken)newAnalyzedTokens.get(0)).getLemma()));
        }
        if ((newAnalyzedTokens = new ArrayList<AnalyzedToken>(new LinkedHashSet<AnalyzedToken>(newAnalyzedTokens))).isEmpty()) {
            newAnalyzedTokens = newAnalyzedTokensAnimInanim;
        }
        if (animInanimNotTagged != null && newAnalyzedTokens.isEmpty()) {
            this.compoundDebugLogger.logUnknownCompound(word + " " + animInanimNotTagged);
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private static String stripPerfImperf(String leftPosTag) {
        return leftPosTag.replaceAll(":(im)?perf|:&adjp:(actv|pasv)", "");
    }

    private boolean isJuniorSenior(AnalyzedToken leftAnalyzedToken, AnalyzedToken rightAnalyzedToken) {
        return leftAnalyzedToken.getPOSTag().matches(".*?:[flp]name.*") && rightAnalyzedToken.getLemma().matches(".*(\u043c\u043e\u043b\u043e\u0434\u0448\u0438\u0439|\u0441\u0442\u0430\u0440\u0448\u0438\u0439)");
    }

    @Nullable
    private String getNumAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv) {
        String leftConj;
        String agreedPosTag = null;
        if ((leftPosTag.contains(":p:") && SING_REGEX_F.matcher(rightPosTag).find() || SING_REGEX_F.matcher(leftPosTag).find() && rightPosTag.contains(":p:")) && (leftConj = PosTagHelper.getConj(leftPosTag)) != null && leftConj.equals(PosTagHelper.getConj(rightPosTag))) {
            agreedPosTag = leftPosTag;
        }
        return agreedPosTag;
    }

    @Nullable
    private String getAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv, String word) {
        String substring2;
        String substring1;
        Matcher stdNounMatcherRight;
        boolean rightPlural;
        boolean leftPlural = CompoundTagger.isPlural(leftPosTag);
        if (leftPlural != (rightPlural = CompoundTagger.isPlural(rightPosTag))) {
            return null;
        }
        if (!CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
            return null;
        }
        Matcher stdNounMatcherLeft = stdNounTagRegex.matcher(leftPosTag);
        if (stdNounMatcherLeft.matches() && (stdNounMatcherRight = stdNounTagRegex.matcher(rightPosTag)).matches() && (substring1 = stdNounMatcherLeft.group(2)).equals(substring2 = stdNounMatcherRight.group(2))) {
            if (!stdNounMatcherLeft.group(1).equals(stdNounMatcherRight.group(1))) {
                this.compoundDebugLogger.logGenderMix(word, leftNv, leftPosTag, rightPosTag);
            }
            if (leftNv) {
                return rightPosTag;
            }
            return leftPosTag;
        }
        return null;
    }

    private static boolean isMinMax(String rightToken) {
        return rightToken.equals("\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c") || rightToken.equals("\u043c\u0456\u043d\u0456\u043c\u0443\u043c");
    }

    @Nullable
    private String tryAnimInanim(String leftPosTag, String rightPosTag, String leftLemma, String rightLemma, boolean leftNv, boolean rightNv, String word) {
        String agreedPosTag = null;
        if (leftMasterSet.contains(leftLemma)) {
            rightPosTag = leftPosTag.contains(TAG_ANIM) ? rightPosTag.replace(TAG_INANIM, TAG_ANIM) : rightPosTag.replace(TAG_ANIM, TAG_INANIM);
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv, word);
            if (agreedPosTag == null) {
                if (!leftPosTag.contains(TAG_ANIM)) {
                    if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                        agreedPosTag = leftPosTag;
                    }
                } else if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_ROD_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                    agreedPosTag = leftPosTag;
                }
            }
        } else if (slaveSet.contains(rightLemma)) {
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag = rightPosTag.replace(TAG_ANIM, TAG_INANIM), false, word);
            if (agreedPosTag == null && leftPosTag.contains(TAG_INANIM) && MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
                agreedPosTag = leftPosTag;
            }
        } else if (slaveSet.contains(leftLemma) && (agreedPosTag = this.getAgreedPosTag(rightPosTag, leftPosTag = leftPosTag.replace(TAG_ANIM, TAG_INANIM), false, word)) == null && rightPosTag.contains(TAG_INANIM) && MNP_ZNA_REGEX.matcher(rightPosTag).matches() && MNP_NAZ_REGEX.matcher(leftPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
            agreedPosTag = rightPosTag;
        }
        return agreedPosTag;
    }

    private static boolean isSameAnimStatus(String leftPosTag, String rightPosTag) {
        boolean rightAnim;
        boolean leftAnim = leftPosTag.contains(TAG_ANIM);
        return leftAnim == (rightAnim = rightPosTag.contains(TAG_ANIM));
    }

    private static boolean isPlural(String posTag) {
        return posTag.startsWith("noun:") && posTag.contains(":p:");
    }

    @Nullable
    private List<AnalyzedToken> oAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        String leftBase = leftWord.substring(0, leftWord.length() - 1);
        String extraTag = "";
        if (!LEFT_O_ADJ.contains(leftWord.toLowerCase(this.conversionLocale))) {
            List<Object> taggedWords = new ArrayList();
            taggedWords = this.tagBothCases(leftWord, Pattern.compile("^adv.*|.*?numr.*"));
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(CompoundTagger.oToYj(leftWord), Pattern.compile("^adj.*"));
            }
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(leftBase, Pattern.compile("^noun.*"));
            }
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(leftBase + "\u0430", Pattern.compile("(noun:inanim:f:v_naz|numr).*"));
            }
            if (taggedWords.isEmpty()) {
                return null;
            }
            if (!extraTag.equals(":bad") && ((TaggedWord)taggedWords.get(0)).getPosTag().startsWith(IPOSTag.adv.getText()) && PosTagHelper.hasPosTagPart(analyzedTokens, "adjp")) {
                extraTag = ":bad";
            }
            if (!extraTag.equals(":bad") && PosTagHelper.hasPosTagPart2(taggedWords, ":bad")) {
                extraTag = ":bad";
            }
        }
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText())) continue;
            if (posTag.contains(":comp")) {
                posTag = PosTagHelper.ADJ_COMP_REGEX.matcher(posTag).replaceFirst("");
            }
            if (!posTag.contains(":bad")) {
                posTag = posTag + extraTag;
            }
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord.toLowerCase() + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> numrAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        String extraTag = "";
        List taggedWords = this.wordTagger.tag(leftWord);
        if (!PosTagHelper.startsWithPosTag(taggedWords, "numr")) {
            return null;
        }
        if (leftWord.matches(".*?(\u0434\u0432\u043e\u0445|\u0442\u0440\u044c\u043e\u0445|\u0447\u043e\u0442\u0438\u0440\u044c\u043e\u0445)")) {
            extraTag = ":bad";
        }
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText())) continue;
            if (posTag.contains(":comp")) {
                posTag = PosTagHelper.ADJ_COMP_REGEX.matcher(posTag).replaceFirst("");
            }
            if (!posTag.contains(":bad")) {
                posTag = posTag + extraTag;
            }
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord.toLowerCase() + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private static String oToYj(String leftWord) {
        return leftWord.endsWith("\u044c\u043e") ? leftWord.substring(0, leftWord.length() - 2) + "\u0456\u0439" : leftWord.substring(0, leftWord.length() - 1) + "\u0438\u0439";
    }

    @Nullable
    private static List<AnalyzedToken> getNvPrefixNounMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.noun.getText()) || posTag.contains("v_kly")) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private static List<AnalyzedToken> getNvPrefixLatWithAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText()) || posTag.contains("v_kly")) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> poAdvMatch(String word, List<AnalyzedToken> analyzedTokens, String adjTag) {
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(adjTag)) continue;
            return Arrays.asList(new AnalyzedToken(word, IPOSTag.adv.getText(), word));
        }
        return null;
    }

    private String capitalize(String word) {
        return word.substring(0, 1).toUpperCase(this.conversionLocale) + word.substring(1, word.length());
    }

    private List<TaggedWord> tagBothCases(String leftWord, Pattern posTagMatcher) {
        List leftWdList = this.wordTagger.tag(leftWord);
        String leftLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (!leftWord.equals(leftLowerCase)) {
            leftWdList.addAll(this.wordTagger.tag(leftLowerCase));
        } else {
            String leftUpperCase = this.capitalize(leftWord);
            if (!leftWord.equals(leftUpperCase)) {
                leftWdList.addAll(this.wordTagger.tag(leftUpperCase));
            }
        }
        if (posTagMatcher != null) {
            leftWdList = leftWdList.stream().filter(word -> posTagMatcher.matcher(word.getPosTag()).matches()).collect(Collectors.toList());
        }
        return leftWdList;
    }

    private List<TaggedWord> tagAsIsAndWithLowerCase(String leftWord) {
        List leftWdList = this.wordTagger.tag(leftWord);
        String leftLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (!leftWord.equals(leftLowerCase)) {
            leftWdList.addAll(this.wordTagger.tag(leftLowerCase));
        }
        return leftWdList;
    }

    static {
        rightPartsWithLeftTagMap = new HashMap<String, Pattern>();
        LEFT_O_ADJ = Arrays.asList("\u0430\u0432\u0441\u0442\u0440\u043e", "\u0430\u0434\u0438\u0433\u043e", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u043e", "\u0430\u043d\u0433\u043b\u043e", "\u0430\u0444\u0440\u043e", "\u0435\u043a\u043e", "\u0435\u0442\u043d\u043e", "\u0456\u0441\u043f\u0430\u043d\u043e", "\u0456\u0442\u0430\u043b\u043e", "\u043a\u0438\u0454\u0432\u043e", "\u043c\u0430\u0440\u043e\u043a\u0430\u043d\u043e", "\u0443\u0433\u0440\u043e");
        LEFT_INVALID = Arrays.asList("\u0430\u0432\u0456\u0430", "\u0430\u0432\u0442\u043e", "\u0430\u0433\u0440\u043e", "\u0430\u043d\u0442\u0438", "\u0430\u0443\u0434\u0456\u043e", "\u0431\u0456\u043e", "\u0432\u0435\u043b\u043e", "\u0432\u0456\u0434\u0435\u043e", "\u0432\u043e\u0434\u043e", "\u0433\u0430\u0437\u043e", "\u0433\u0435\u043b\u0456\u043e", "\u0433\u0435\u043e", "\u0433\u0456\u0434\u0440\u043e", "\u0434\u0430\u0432\u043d\u044c\u043e", "\u0434\u0440\u0435\u0432\u043d\u044c\u043e", "\u0435\u043a\u0437\u043e", "\u0435\u043a\u0441\u0442\u0440\u0430", "\u0435\u043b\u0435\u043a\u0442\u0440\u043e", "\u0437\u043e\u043e", "\u0456\u0437\u043e", "\u043a\u0432\u0430\u0437\u0456", "\u043a\u0456\u043d\u043e", "\u043a\u043e\u0441\u043c\u043e", "\u043a\u043e\u043d\u0442\u0440", "\u043b\u0436\u0435", "\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e", "\u043c\u0456\u043d\u0456\u043c\u0430\u043b\u044c\u043d\u043e", "\u043c\u0430\u043a\u0440\u043e", "\u043c\u0435\u0442\u0430", "\u043c\u0435\u0442\u0435\u043e", "\u043c\u0456\u043a\u0440\u043e", "\u043c\u0456\u043b\u0456", "\u043c\u043e\u043d\u043e", "\u043c\u043e\u0442\u043e", "\u043c\u0443\u043b\u044c\u0442\u0438", "\u043d\u0430\u043f\u0456\u0432", "\u043d\u0435\u043e", "\u043f\u0430\u043b\u0435\u043e", "\u043f\u043e\u0441\u0442", "\u043f\u0441\u0435\u0432\u0434\u043e", "\u0440\u0430\u0434\u0456\u043e", "\u0440\u0435\u043d\u0442\u0433\u0435\u043d\u043e", "\u0441\u043e\u0446\u0456\u043e", "\u0441\u0442\u0435\u0440\u0435\u043e", "\u0441\u0443\u043f\u0435\u0440", "\u0442\u0435\u043b\u0435", "\u0442\u0435\u0440\u043c\u043e", "\u0442\u0443\u0440\u0431\u043e", "\u0443\u043b\u044c\u0442\u0440\u0430", "\u0444\u043e\u043d\u043e", "\u0444\u043e\u0442\u043e");
        LEFT_O_ADJ_INVALID = Arrays.asList("\u0431\u0430\u0433\u0430\u0442\u043e", "\u043c\u0430\u043b\u043e", "\u0432\u0438\u0441\u043e\u043a\u043e", "\u043d\u0438\u0437\u044c\u043a\u043e", "\u0441\u0442\u0430\u0440\u043e", "\u043d\u043e\u0432\u043e");
        WORDS_WITH_YEAR = Arrays.asList("\u0433\u0440\u0430", "\u0431\u044e\u0434\u0436\u0435\u0442", "\u0432\u0438\u0431\u043e\u0440\u0438", "\u043e\u043b\u0456\u043c\u043f\u0456\u0430\u0434\u0430", "\u0443\u043d\u0456\u0432\u0435\u0440\u0441\u0456\u0430\u0434\u0430");
        WORDS_WITH_NUM = Arrays.asList("\u0424\u043e\u0440\u043c\u0443\u043b\u0430", "\u041a\u0430\u0440\u043f\u0430\u0442\u0438", "\u0414\u0438\u043d\u0430\u043c\u043e", "\u0428\u0430\u0445\u0442\u0430\u0440", "\u0424\u0443\u043a\u0443\u0441\u0456\u043c\u0430", "\u043e\u043c\u0435\u0433\u0430");
        rightPartsWithLeftTagMap.put("\u0431\u043e", Pattern.compile("(verb|.*?pron|noun|adv|intj|part).*"));
        rightPartsWithLeftTagMap.put("\u043d\u043e", Pattern.compile("(verb.*?:(impr|futr|&insert)|intj).*"));
        rightPartsWithLeftTagMap.put("\u043e\u0442", Pattern.compile("(.*?pron|adv|part|verb).*"));
        rightPartsWithLeftTagMap.put("\u0442\u043e", Pattern.compile("(.*?pron|verb|noun|adj|conj).*"));
        rightPartsWithLeftTagMap.put("\u0442\u0430\u043a\u0438", Pattern.compile("(verb|adv|adj|.*?pron|part|noninfl:&predic).*"));
        dashPrefixes = ExtraDictionaryLoader.loadSet("/uk/dash_prefixes.txt");
        dashPrefixes2 = ExtraDictionaryLoader.loadSet("/uk/dash_prefixes2.txt");
        leftMasterSet = ExtraDictionaryLoader.loadSet("/uk/dash_left_master.txt");
        slaveSet = ExtraDictionaryLoader.loadSet("/uk/dash_slaves.txt");
        numberedEntities = ExtraDictionaryLoader.loadSpacedLists("/uk/entities.txt");
    }
}

