/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Ukrainian;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.disambiguation.AbstractDisambiguator;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.MultiWordChunker;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.uk.PosTagHelper;

public class UkrainianHybridDisambiguator
extends AbstractDisambiguator {
    private static final String LAST_NAME_TAG = ":lname";
    private static final Pattern INITIAL_REGEX = Pattern.compile("[\u0410-\u042f\u0406\u0407\u0404\u0490]\\.");
    private static final Pattern INANIM_VKLY = Pattern.compile("noun:inanim:.:v_kly.*");
    private static final Pattern PLURAL_NAME = Pattern.compile("noun:anim:p:.*:fname.*");
    private static final String PLURAL_LNAME = "noun:anim:p:.*:(lname|patr).*";
    private final Disambiguator chunker = new MultiWordChunker("/uk/multiwords.txt", true);
    private final Disambiguator disambiguator = new XmlRuleDisambiguator((Language)new Ukrainian());

    public final AnalyzedSentence disambiguate(AnalyzedSentence input) throws IOException {
        this.preDisambiguate(input);
        return this.disambiguator.disambiguate(this.chunker.disambiguate(input));
    }

    public AnalyzedSentence preDisambiguate(AnalyzedSentence input) {
        this.retagInitials(input);
        this.removeIanimVKly(input);
        this.removePluralForNames(input);
        return input;
    }

    private void removeIanimVKly(AnalyzedSentence input) {
        AnalyzedTokenReadings[] tokens = input.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String posTag;
            List analyzedTokens = tokens[i].getReadings();
            if (i < tokens.length - 1 && Arrays.asList(",", "!", "\u00bb").contains(tokens[i + 1].getToken()) && PosTagHelper.hasPosTag(tokens[i - 1], "adj.*v_kly.*")) continue;
            ArrayList inanimVklyReadings = new ArrayList();
            boolean otherFound = false;
            for (int j = 0; j < analyzedTokens.size() && (posTag = ((AnalyzedToken)analyzedTokens.get(j)).getPOSTag()) != null; ++j) {
                if (posTag.equals("SENT_END")) continue;
                if (INANIM_VKLY.matcher(posTag).matches()) {
                    inanimVklyReadings.add(analyzedTokens.get(j));
                    continue;
                }
                otherFound = true;
            }
            if (inanimVklyReadings.size() <= 0 || !otherFound) continue;
            for (AnalyzedToken analyzedToken : inanimVklyReadings) {
                tokens[i].removeReading(analyzedToken);
            }
        }
    }

    private void removePluralForNames(AnalyzedSentence input) {
        AnalyzedTokenReadings[] tokens = input.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String posTag;
            List analyzedTokens = tokens[i].getReadings();
            if (i > 1 && (PosTagHelper.hasPosTag(tokens[i - 1], "adj:p:.*") || PosTagHelper.hasPosTag(tokens[i - 1], ".*num.*") || LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0431\u0430\u0433\u0430\u0442\u043e", "\u043c\u0430\u043b\u043e", "\u043f\u0456\u0432\u0441\u043e\u0442\u043d\u044f", "\u0441\u043e\u0442\u043d\u044f"))) || i < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[i + 1], PLURAL_LNAME) || i < tokens.length - 3 && PosTagHelper.hasPosTagPart(tokens[i + 1], LAST_NAME_TAG) && PosTagHelper.hasPosTagPart(tokens[i + 3], LAST_NAME_TAG)) continue;
            ArrayList pluralNameReadings = new ArrayList();
            boolean otherFound = false;
            for (int j = 0; j < analyzedTokens.size() && (posTag = ((AnalyzedToken)analyzedTokens.get(j)).getPOSTag()) != null; ++j) {
                if (posTag.equals("SENT_END")) continue;
                if (PLURAL_NAME.matcher(posTag).matches()) {
                    pluralNameReadings.add(analyzedTokens.get(j));
                    continue;
                }
                otherFound = true;
            }
            if (pluralNameReadings.size() <= 0 || !otherFound) continue;
            for (AnalyzedToken analyzedToken : pluralNameReadings) {
                tokens[i].removeReading(analyzedToken);
            }
        }
    }

    private void retagInitials(AnalyzedSentence input) {
        AnalyzedTokenReadings[] tokens = input.getTokens();
        for (int i = 1; i < tokens.length - 1; ++i) {
            AnalyzedTokenReadings newReadings;
            if (!UkrainianHybridDisambiguator.isInitial(tokens, i)) continue;
            boolean spaced = UkrainianHybridDisambiguator.isSpace(tokens[i + 1].getToken());
            int spacedOffset = spaced ? 1 : 0;
            int nextPos = i + 1 + spacedOffset;
            if (nextPos + 1 + spacedOffset < tokens.length && UkrainianHybridDisambiguator.isInitial(tokens, nextPos) && (!spaced || UkrainianHybridDisambiguator.isSpace(tokens[nextPos + 1].getToken())) && tokens[nextPos + 1 + spacedOffset].hasPartialPosTag(LAST_NAME_TAG)) {
                AnalyzedTokenReadings newReadings2;
                int currPos = nextPos;
                tokens[currPos] = newReadings2 = UkrainianHybridDisambiguator.getInitialReadings(tokens[currPos], tokens[nextPos += 1 + spacedOffset], "patr");
            }
            if (nextPos >= tokens.length || !tokens[nextPos].hasPartialPosTag(LAST_NAME_TAG)) continue;
            tokens[i] = newReadings = UkrainianHybridDisambiguator.getInitialReadings(tokens[i], tokens[nextPos], "fname");
            i = nextPos;
        }
    }

    private static AnalyzedTokenReadings getInitialReadings(AnalyzedTokenReadings initialsReadings, AnalyzedTokenReadings lnameTokens, String initialType) {
        ArrayList<AnalyzedToken> newTokens = new ArrayList<AnalyzedToken>();
        for (AnalyzedToken lnameToken : lnameTokens.getReadings()) {
            String lnamePosTag = lnameToken.getPOSTag();
            if (lnamePosTag == null || !lnamePosTag.contains(LAST_NAME_TAG)) continue;
            String initialsToken = initialsReadings.getAnalyzedToken(0).getToken();
            AnalyzedToken newToken = new AnalyzedToken(initialsToken, lnamePosTag.replace(LAST_NAME_TAG, ":" + initialType + ":abbr"), initialsToken);
            newTokens.add(newToken);
        }
        return new AnalyzedTokenReadings(newTokens, initialsReadings.getStartPos());
    }

    private static boolean isInitial(AnalyzedTokenReadings[] tokens, int pos) {
        return pos < tokens.length - 1 && INITIAL_REGEX.matcher(tokens[pos].getToken()).matches();
    }

    private static boolean isSpace(String str) {
        return str != null && (str.equals(" ") || str.equals("\u00a0"));
    }
}

