/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Ukrainian;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementAdjNounExceptionHelper;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.uk.PosTagHelper;

public class TokenAgreementAdjNounRule
extends Rule {
    static final Pattern ADJ_INFLECTION_PATTERN = Pattern.compile(":([mfnp]):(v_...)(:r(in)?anim)?");
    static final Pattern NOUN_INFLECTION_PATTERN = Pattern.compile("(?::((?:[iu]n)?anim))?:([mfnps]):(v_...)");
    static boolean DEBUG = Boolean.getBoolean("org.languagetool.rules.uk.TokenInflectionAgreementRule.debug");
    private static final String NO_VIDMINOK_SUBSTR = ":nv";
    private final Ukrainian ukrainian = new Ukrainian();

    public TokenAgreementAdjNounRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public final String getId() {
        return "UK_ADJ_NOUN_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0456\u0432, \u0440\u043e\u0434\u0443 \u0456 \u0447\u0438\u0441\u043b\u0430 \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430";
    }

    public final RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        ArrayList<AnalyzedToken> adjTokenReadings = new ArrayList<AnalyzedToken>();
        AnalyzedTokenReadings adjAnalyzedTokenReadings = null;
        block2: for (int i = 1; i < tokens.length; ++i) {
            List<InflectionHelper.Inflection> slaveInflections;
            List<InflectionHelper.Inflection> masterInflections;
            Iterator token2;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String posTag0 = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag0 == null) {
                adjTokenReadings.clear();
                continue;
            }
            if (adjTokenReadings.isEmpty()) {
                if (i == tokens.length - 1 || PosTagHelper.hasPosTagPart(tokens[i], NO_VIDMINOK_SUBSTR) || PosTagHelper.hasPosTagPart(tokens[i], "&pron") || PosTagHelper.hasPosTagPart(tokens[i], "<") || !PosTagHelper.hasPosTagPart(tokens[i + 1], "noun:") || PosTagHelper.hasPosTagPart(tokens[i + 1], NO_VIDMINOK_SUBSTR) || PosTagHelper.hasPosTagPart(tokens[i + 1], "&pron") || PosTagHelper.hasPosTagPart(tokens[i + 1], "<")) continue;
                if (LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u0447\u0435\u0440\u0432\u043e\u043d\u0438\u0439", "\u043f\u0440\u0430\u0432\u0438\u0439", "\u043c\u0456\u0441\u0446\u0435\u0432\u0438\u0439", "\u043d\u0430\u0439\u0441\u0438\u043b\u044c\u043d\u0456\u0448\u0438\u0439", "\u043d\u0430\u0439\u043a\u0440\u0430\u0449\u0456"), ":p:") || LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u043d\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u0439", "\u0433\u043e\u043b\u043e\u0432\u043d\u0438\u0439", "\u0432\u0438\u0431\u0440\u0430\u043d\u0438\u0439", "\u0431\u0456\u043b\u044c\u0448\u0438\u0439", "\u043f\u043e\u0431\u0430\u0447\u0435\u043d\u0438\u0439", "\u043f\u043e\u0434\u0456\u0431\u043d\u0438\u0439"), ":n:") || LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u0434\u0435\u0440\u0436\u0430\u0432\u043d\u0438\u0439"), ":f:")) {
                    adjTokenReadings.clear();
                    break;
                }
                for (Iterator token2 : tokenReadings) {
                    String adjPosTag = token2.getPOSTag();
                    if (adjPosTag == null) continue;
                    if (adjPosTag.startsWith("adj")) {
                        adjTokenReadings.add((AnalyzedToken)token2);
                        adjAnalyzedTokenReadings = tokenReadings;
                        continue;
                    }
                    adjTokenReadings.clear();
                    continue block2;
                }
                continue;
            }
            ArrayList<AnalyzedToken> slaveTokenReadings = new ArrayList<AnalyzedToken>();
            token2 = tokenReadings.iterator();
            while (token2.hasNext()) {
                AnalyzedToken token3 = (AnalyzedToken)token2.next();
                String nounPosTag = token3.getPOSTag();
                if (nounPosTag == null) continue;
                if (nounPosTag.startsWith("noun") && !nounPosTag.contains(NO_VIDMINOK_SUBSTR)) {
                    slaveTokenReadings.add(token3);
                    continue;
                }
                if (nounPosTag.equals("SENT_END") || nounPosTag.equals("PARA_END")) continue;
                slaveTokenReadings.clear();
                break;
            }
            if (slaveTokenReadings.isEmpty()) {
                adjTokenReadings.clear();
                continue;
            }
            if (DEBUG) {
                System.err.println(MessageFormat.format("=== Checking:\n\t{0}\n\t{1}", adjTokenReadings, slaveTokenReadings));
            }
            if (Collections.disjoint(masterInflections = InflectionHelper.getAdjInflections(adjTokenReadings), slaveInflections = InflectionHelper.getNounInflections(slaveTokenReadings))) {
                if (TokenAgreementAdjNounExceptionHelper.isException(tokens, i, masterInflections, slaveInflections, adjTokenReadings, slaveTokenReadings)) {
                    adjTokenReadings.clear();
                    continue;
                }
                if (DEBUG) {
                    System.err.println(MessageFormat.format("=== Found:\n\t{0}\n\t", adjAnalyzedTokenReadings.getToken() + ": " + masterInflections + " // " + adjAnalyzedTokenReadings, ((AnalyzedToken)slaveTokenReadings.get(0)).getToken() + ": " + slaveInflections + " // " + slaveTokenReadings));
                }
                String msg = String.format("\u041f\u043e\u0442\u0435\u043d\u0446\u0456\u0439\u043d\u0430 \u043f\u043e\u043c\u0438\u043b\u043a\u0430: \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a \u043d\u0435 \u0443\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u0438\u0439 \u0437 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c: \"%s\": [%s] \u0456 \"%s\": [%s]", ((AnalyzedToken)adjTokenReadings.get(0)).getToken(), TokenAgreementAdjNounRule.formatInflections(masterInflections, true), ((AnalyzedToken)slaveTokenReadings.get(0)).getToken(), TokenAgreementAdjNounRule.formatInflections(slaveInflections, false));
                if (PosTagHelper.hasPosTagPart(adjTokenReadings, ":m:v_rod") && tokens[i].getToken().matches(".*[\u0443\u044e]") && PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*:m:v_dav.*")) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e \u0432\u0436\u0438\u0442\u043e \u043d\u0435\u0432\u043d\u043e\u0440\u043c\u043e\u0432\u0430\u043d\u0438\u0439 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a \u0447.\u0440. \u0437 \u0437\u0430\u043a\u0456\u043d\u0447\u0435\u043d\u043d\u044f\u043c -\u0443/-\u044e \u0437\u0430\u043c\u0456\u0441\u0442\u044c -\u0430/-\u044f (\u0442\u0430\u043a\u0430 \u0442\u0435\u043d\u0434\u0435\u043d\u0446\u0456\u044f \u0454 \u0432 \u0441\u0443\u0447\u0430\u0441\u043d\u0456\u0439 \u043c\u043e\u0432\u0456)?";
                }
                RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, adjAnalyzedTokenReadings.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                Synthesizer ukrainianSynthesizer = this.ukrainian.getSynthesizer();
                ArrayList<String> suggestions = new ArrayList<String>();
                try {
                    String suggestion;
                    String[] synthesized;
                    String vidmTag;
                    String genderTag;
                    for (InflectionHelper.Inflection adjInflection : masterInflections) {
                        genderTag = ":" + adjInflection.gender + ":";
                        vidmTag = adjInflection._case;
                        if (adjInflection._case.equals("v_kly") || !adjInflection.gender.equals("p") && !PosTagHelper.hasPosTagPart(slaveTokenReadings, genderTag)) continue;
                        for (AnalyzedToken nounToken : slaveTokenReadings) {
                            if (adjInflection.animMatters() && !nounToken.getPOSTag().contains(":" + adjInflection.animTag)) continue;
                            String newNounPosTag = nounToken.getPOSTag().replaceFirst(":.:v_...", genderTag + vidmTag);
                            for (String s : synthesized = ukrainianSynthesizer.synthesize(nounToken, newNounPosTag, false)) {
                                suggestion = adjAnalyzedTokenReadings.getToken() + " " + s;
                                if (suggestions.contains(suggestion)) continue;
                                suggestions.add(suggestion);
                            }
                        }
                    }
                    for (InflectionHelper.Inflection nounInflection : slaveInflections) {
                        genderTag = ":" + nounInflection.gender + ":";
                        vidmTag = nounInflection._case;
                        if (nounInflection.animMatters()) {
                            vidmTag = vidmTag + ":r" + nounInflection.animTag;
                        }
                        for (AnalyzedToken adjToken : adjTokenReadings) {
                            String newAdjTag = adjToken.getPOSTag().replaceFirst(":.:v_...(:r(in)?anim)?", genderTag + vidmTag);
                            for (String s : synthesized = ukrainianSynthesizer.synthesize(adjToken, newAdjTag, false)) {
                                suggestion = s + " " + tokenReadings.getToken();
                                if (suggestions.contains(suggestion)) continue;
                                suggestions.add(suggestion);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (suggestions.size() > 0) {
                    potentialRuleMatch.setSuggestedReplacements(suggestions);
                }
                ruleMatches.add(potentialRuleMatch);
            }
            adjTokenReadings.clear();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static String formatInflections(List<InflectionHelper.Inflection> inflections, boolean adj) {
        Collections.sort(inflections);
        LinkedHashMap map = new LinkedHashMap();
        for (InflectionHelper.Inflection inflection : inflections) {
            if (!map.containsKey(inflection.gender)) {
                map.put(inflection.gender, new ArrayList());
            }
            String caseStr = PosTagHelper.VIDMINKY_MAP.get(inflection._case);
            if (adj && inflection.animTag != null) {
                caseStr = caseStr + " (" + (inflection.animTag.equals("ranim") ? "\u0456\u0441\u0442." : "\u043d\u0435\u0456\u0441\u0442.") + ")";
            }
            ((List)map.get(inflection.gender)).add(caseStr);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            String genderStr = PosTagHelper.GENDER_MAP.get(entry.getKey());
            List caseValues = (List)entry.getValue();
            list.add(genderStr + ": " + StringUtils.join((Iterable)caseValues, (String)", "));
        }
        return StringUtils.join(list, (String)", ");
    }
}

