/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenInflectionExceptionHelper;
import org.languagetool.rules.uk.TokenVerbAgreementRule;
import org.languagetool.tagging.uk.PosTagHelper;

public final class TokenVerbAgreementExceptionHelper {
    private TokenVerbAgreementExceptionHelper() {
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, int i, List<TokenVerbAgreementRule.Inflection> masterInflections, List<TokenVerbAgreementRule.Inflection> slaveInflections, List<AnalyzedToken> nounTokenReadings, List<AnalyzedToken> verbTokenReadings) {
        int verbPos;
        if (PosTagHelper.hasPosTag(verbTokenReadings, ".*:p(:.*|$)")) {
            if (LemmaHelper.tokenSearch(tokens, i - 2, null, TokenInflectionExceptionHelper.CONJ_FOR_PLULAR_PATTERN, Pattern.compile("(noun|adj).*"), LemmaHelper.Dir.REVERSE) != -1) {
                TokenVerbAgreementExceptionHelper.logException();
                return true;
            }
            int pos = LemmaHelper.tokenSearch(tokens, i - 2, null, Pattern.compile(","), Pattern.compile("adj.*"), LemmaHelper.Dir.REVERSE);
            if (pos > 1 && PosTagHelper.hasPosTagPart(tokens[pos - 1], "noun")) {
                TokenVerbAgreementExceptionHelper.logException();
                return true;
            }
        }
        if ((verbPos = LemmaHelper.tokenSearch(tokens, i - 2, "verb", null, Pattern.compile("(adv|part).*"), LemmaHelper.Dir.REVERSE)) != -1 && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:inf.*") && !Collections.disjoint(TokenVerbAgreementRule.getVerbInflections(tokens[verbPos].getReadings()), masterInflections)) {
            TokenVerbAgreementExceptionHelper.logException();
            return true;
        }
        if (i > 1 && PosTagHelper.hasPosTagPart(tokens[i - 2], "adj") && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:inf.*") && CaseGovernmentHelper.hasCaseGovernment(tokens[i - 2], "v_inf") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[i - 2].getReadings()), InflectionHelper.getNounInflections(nounTokenReadings))) {
            TokenVerbAgreementExceptionHelper.logException();
            return true;
        }
        verbPos = LemmaHelper.tokenSearch(tokens, i + 1, "verb", null, Pattern.compile("(adv|part).*"), LemmaHelper.Dir.FORWARD);
        if (verbPos != -1 && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:inf.*") && !Collections.disjoint(TokenVerbAgreementRule.getVerbInflections(tokens[verbPos].getReadings()), masterInflections)) {
            TokenVerbAgreementExceptionHelper.logException();
            return true;
        }
        int adjPos = LemmaHelper.tokenSearch(tokens, i + 1, "adj", null, Pattern.compile("(adv|part).*"), LemmaHelper.Dir.FORWARD);
        if (adjPos != -1 && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:inf.*") && CaseGovernmentHelper.hasCaseGovernment(tokens[adjPos], "v_inf") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[adjPos].getReadings()), InflectionHelper.getNounInflections(nounTokenReadings))) {
            TokenVerbAgreementExceptionHelper.logException();
            return true;
        }
        if (tokens[i - 1].getToken().equalsIgnoreCase("\u0440\u0435\u0448\u0442\u0430") && PosTagHelper.hasPosTag(verbTokenReadings, ".*:p(:.*|$)")) {
            TokenVerbAgreementExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(tokens[i - 1], "noun.*:v_naz.*") && LemmaHelper.tokenSearch(tokens, i - 2, null, Pattern.compile("[\u042f\u044f]\u043a"), Pattern.compile("adj.*"), LemmaHelper.Dir.REVERSE) != -1) {
            TokenVerbAgreementExceptionHelper.logException();
            return true;
        }
        return false;
    }

    private static void logException() {
        if (TokenVerbAgreementRule.DEBUG) {
            StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
            System.err.println("exception: " + stackTraceElement.getFileName() + ": " + stackTraceElement.getLineNumber());
        }
    }
}

