/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.tagging.TamilTagger;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Tamil
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private Tagger tagger;
    private String name = "Tamil";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String getShortName() {
        return "ta";
    }

    public final String[] getCountries() {
        return new String[]{"IN"};
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new TamilTagger();
        }
        return this.tagger;
    }

    public final Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Elanjelian Venugopal")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages), new SentenceWhitespaceRule(messages));
    }
}

