/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.language.SerbianSerbian;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.sr.ekavian.MorfologikEkavianSpellerRule;
import org.languagetool.rules.sr.ekavian.SimpleGrammarEkavianReplaceRule;
import org.languagetool.rules.sr.ekavian.SimpleStyleEkavianReplaceRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.sr.EkavianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.sr.SerbianHybridDisambiguator;
import org.languagetool.tagging.sr.EkavianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Serbian
extends Language {
    private static final Language SERBIA_SERBIAN = new SerbianSerbian();
    private SentenceTokenizer sentenceTokenizer;
    private Tagger tagger;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private static final List<String> RULE_FILES = Arrays.asList("grammar-barbarism.xml", "grammar-logical.xml", "grammar-punctuation.xml", "grammar-spelling.xml", "grammar-style.xml");

    public String getName() {
        return "Serbian";
    }

    public String getShortCode() {
        return "sr";
    }

    public String[] getCountries() {
        return new String[0];
    }

    public Language getDefaultLanguageVariant() {
        return SERBIA_SERBIAN;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("\u0417\u043e\u043b\u0442\u0430\u043d \u0427\u0430\u043b\u0430 (Csala, Zolt\u00e1n)")};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new EkavianTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new EkavianSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new SerbianHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected List<Rule> getBasicRules(ResourceBundle messages) {
        return Arrays.asList(new CommaWhitespaceRule(messages, Example.wrong((String)"\u041d\u0438\u0458\u0435 \u0448\u0438\u0458\u0430<marker> ,</marker> \u043d\u0435\u0433\u043e \u0432\u0440\u0430\u0442."), Example.fixed((String)"\u041d\u0438\u0458\u0435 \u0448\u0438\u0458\u0430<marker>,</marker> \u043d\u0435\u0433\u043e \u0432\u0440\u0430\u0442.")), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201e", "\u201e", "\""), Arrays.asList("]", ")", "}", "\u201d", "\u201c", "\"")), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"\u041f\u043e\u0447\u0435\u043b\u0430 \u0458\u0435 \u0448\u043a\u043e\u043b\u0430. <marker>\u0452\u0430\u0446\u0438</marker> \u0441\u0443 \u043f\u043e\u043d\u043e\u0432\u043e \u0441\u0435\u043b\u0438 \u0443 \u043a\u043b\u0443\u043f\u0435."), Example.fixed((String)"\u041f\u043e\u0447\u0435\u043b\u0430 \u0458\u0435 \u0448\u043a\u043e\u043b\u0430. <marker>\u0402\u0430\u0446\u0438</marker> \u0441\u0443 \u043f\u043e\u043d\u043e\u0432\u043e \u0441\u0435\u043b\u0438 \u0443 \u043a\u043b\u0443\u043f\u0435.")), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WordRepeatRule(messages, (Language)this));
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(this.getBasicRules(messages));
        rules.add((Rule)new MorfologikEkavianSpellerRule(messages, this, null));
        rules.add((Rule)new SimpleGrammarEkavianReplaceRule(messages));
        rules.add((Rule)new SimpleStyleEkavianReplaceRule(messages));
        return rules;
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String shortCode = this.getShortCode();
        String dirBase = dataBroker.getRulesDir();
        for (String ruleFile : RULE_FILES) {
            String rulePath = shortCode + "/" + ruleFile;
            if (!dataBroker.ruleFileExists(rulePath)) continue;
            ruleFileNames.add(dirBase + "/" + rulePath);
        }
        return ruleFileNames;
    }
}

