/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.ru.MorfologikRussianSpellerRule;
import org.languagetool.rules.ru.RussianCompoundRule;
import org.languagetool.rules.ru.RussianConfusionProbabilityRule;
import org.languagetool.rules.ru.RussianSimpleReplaceRule;
import org.languagetool.rules.ru.RussianUnpairedBracketsRule;
import org.languagetool.rules.ru.RussianWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ru.RussianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ru.RussianHybridDisambiguator;
import org.languagetool.tagging.ru.RussianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Russian
extends Language
implements AutoCloseable {
    private Tagger tagger;
    private Disambiguator disambiguator;
    private Synthesizer synthesizer;
    private SentenceTokenizer sentenceTokenizer;
    private LuceneLanguageModel languageModel;

    public String getName() {
        return "Russian";
    }

    public String getShortName() {
        return "ru";
    }

    public String[] getCountries() {
        return new String[]{"RU"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new RussianTagger();
        }
        return this.tagger;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new RussianHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new RussianSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Yakov Reztsov", "http://myooo.ru/content/view/83/43/")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this), new MorfologikRussianSpellerRule(messages, this), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new RussianUnpairedBracketsRule(messages, this), new RussianCompoundRule(messages), new RussianSimpleReplaceRule(messages), new RussianWordRepeatRule(messages)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(new File(indexDir, this.getShortName()));
        }
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new RussianConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }
}

