/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.ro.CompoundRule;
import org.languagetool.rules.ro.MorfologikRomanianSpellerRule;
import org.languagetool.rules.ro.RomanianWordRepeatBeginningRule;
import org.languagetool.rules.ro.SimpleReplaceRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ro.RomanianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.ro.RomanianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ro.RomanianWordTokenizer;

public class Romanian
extends Language {
    public String getName() {
        return "Romanian";
    }

    public String getShortCode() {
        return "ro";
    }

    public String[] getCountries() {
        return new String[]{"RO"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new RomanianTagger();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Ionu\u021b P\u0103duraru", "http://www.archeus.ro")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201e", "\u00ab", "\u00bb"), Arrays.asList("]", ")", "}", "\u201d", "\u00bb", "\u00ab")), new WordRepeatRule(messages, (Language)this), new MorfologikRomanianSpellerRule(messages, this, userConfig, altLanguages), new RomanianWordRepeatBeginningRule(messages, this), new SimpleReplaceRule(messages), new CompoundRule(messages, this, userConfig)});
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return RomanianSynthesizer.INSTANCE;
    }

    public Disambiguator createDefaultDisambiguator() {
        return new XmlRuleDisambiguator((Language)this);
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new RomanianWordTokenizer();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikRomanianSpellerRule(messages, this, null, null);
    }
}

