/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.ManualTagger;

public class RomanianTagger
extends BaseTagger {
    private static final String DEFAULT_BINARY_DICT = "/ro/romanian.dict";
    private static final String DEFAULT_PLAINTEXT_DICT = "/ro/added.txt";
    private static final Locale RO_LOCALE = new Locale("ro");
    private final String binaryDictPath;
    private final String plaintextDictPath;
    private ManualTagger manualTagger;

    public RomanianTagger() {
        this(DEFAULT_BINARY_DICT, DEFAULT_PLAINTEXT_DICT);
    }

    public RomanianTagger(String dictFileName, String userDictFileName) {
        this.binaryDictPath = dictFileName;
        this.plaintextDictPath = userDictFileName;
        this.setLocale(RO_LOCALE);
    }

    public final String getFileName() {
        return this.binaryDictPath;
    }

    public String getManualAdditionsFileName() {
        return null;
    }

    public final List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup morfologik = new DictionaryLookup(this.getDictionary());
        if (this.manualTagger == null && this.plaintextDictPath != null) {
            this.manualTagger = new ManualTagger(JLanguageTool.getDataBroker().getFromResourceDirAsStream(this.plaintextDictPath));
        }
        for (String word : sentenceTokens) {
            String[] manualTags;
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerCaseWord = word.toLowerCase(RO_LOCALE);
            List taggerTokens = morfologik.lookup((CharSequence)lowerCaseWord);
            if (taggerTokens != null) {
                for (WordData wd : taggerTokens) {
                    String[] tagsArr;
                    for (String currTag : tagsArr = wd.getStem().toString().split("\\+")) {
                        l.add(new AnalyzedToken(word, wd.getTag().toString(), currTag));
                    }
                }
            }
            if (this.manualTagger != null && (manualTags = this.manualTagger.lookup(lowerCaseWord)) != null) {
                for (int i = 0; i < manualTags.length / 2; i += 2) {
                    l.add(new AnalyzedToken(word, manualTags[i + 1], manualTags[i]));
                }
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }
}

