/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.pt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class PortugueseTagger
extends BaseTagger {
    private static final Pattern ADJ_PART_FS = Pattern.compile("V.P..SF.|A[QO].[FC][SN].");
    private static final Pattern VERB = Pattern.compile("V.+");
    private static final Pattern PREFIXES_FOR_VERBS = Pattern.compile("(soto-)(...+)", 66);
    private static final String ORDINAL_SUFFIX_MASC = "o\u00ba\u1d52";
    private static final String ORDINAL_SUFFIX_FEM = "a\u00aa\u1d43";
    private static final String ORDINAL_SUFFIX_PL = "s\u02e2";
    private static final String ORDINAL_SUFFIXES = String.format("[%s%s][%s]?", "o\u00ba\u1d52", "a\u00aa\u1d43", "s\u02e2");
    private static final Pattern ORDINAL_PATTERN = Pattern.compile("^\\d+[\\d,.]*\\.?" + ORDINAL_SUFFIXES + "$");
    private static final Pattern ORDINAL_MASC_SG = Pattern.compile(String.format("[%s]$", "o\u00ba\u1d52"));
    private static final Pattern ORDINAL_FEM_SG = Pattern.compile(String.format("[%s]$", "a\u00aa\u1d43"));
    private static final Pattern ORDINAL_MASC_PL = Pattern.compile(String.format("[%s][%s]$", "o\u00ba\u1d52", "s\u02e2"));
    private static final Pattern ORDINAL_FEM_PL = Pattern.compile(String.format("[%s][%s]$", "a\u00aa\u1d43", "s\u02e2"));
    private static final Pattern PERCENT_PATTERN = Pattern.compile("\u2212?\\d+[\\d,.]*%");
    private static final Pattern DEGREE_PATTERN = Pattern.compile("\u2212?\\d+[\\d,.]*\u00b0");

    public PortugueseTagger() {
        super("/pt/portuguese.dict", new Locale("pt"));
    }

    private List<AnalyzedToken> tagNumberExpressions(String word) {
        if (this.isOrdinal(word)) {
            return this.buildOrdinalTokens(word);
        }
        if (this.isDegree(word)) {
            return Collections.singletonList(this.buildMascPlNoun(word));
        }
        if (this.isPercent(word)) {
            return Collections.singletonList(this.buildMascPlNoun(word));
        }
        return Collections.emptyList();
    }

    private AnalyzedToken buildMascPlNoun(String word) {
        return new AnalyzedToken(word, "NCMP000", word);
    }

    private List<AnalyzedToken> buildOrdinalTokens(String word) {
        ArrayList<AnalyzedToken> resultTokens = new ArrayList<AnalyzedToken>(Collections.emptyList());
        String lemma = word.replaceAll(ORDINAL_SUFFIXES, "\u00ba");
        String numberGenderTags = "";
        if (ORDINAL_MASC_SG.matcher(word).find()) {
            numberGenderTags = "MS";
        }
        if (ORDINAL_FEM_SG.matcher(word).find()) {
            numberGenderTags = "FS";
        }
        if (ORDINAL_MASC_PL.matcher(word).find()) {
            numberGenderTags = "MP";
        }
        if (ORDINAL_FEM_PL.matcher(word).find()) {
            numberGenderTags = "FP";
        }
        String nounTag = String.format("NC%s000", numberGenderTags);
        String adjTag = String.format("AO0%s0", numberGenderTags);
        AnalyzedToken nounToken = new AnalyzedToken(word, nounTag, lemma);
        AnalyzedToken adjToken = new AnalyzedToken(word, adjTag, lemma);
        resultTokens.add(nounToken);
        resultTokens.add(adjToken);
        return resultTokens;
    }

    private boolean isOrdinal(String word) {
        Matcher matcher = ORDINAL_PATTERN.matcher(word);
        return matcher.matches();
    }

    private boolean isPercent(String word) {
        Matcher matcher = PERCENT_PATTERN.matcher(word);
        return matcher.matches();
    }

    private boolean isDegree(String word) {
        Matcher matcher = DEGREE_PATTERN.matcher(word);
        return matcher.matches();
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        for (String word : sentenceTokens) {
            boolean isMixedCase;
            boolean ignoreSpelling = false;
            boolean containsTypewriterApostrophe = false;
            if (word.length() > 1) {
                if (word.contains("'")) {
                    containsTypewriterApostrophe = true;
                }
                word = word.replace('\u2019', '\'');
            }
            ArrayList<AnalyzedToken> analyzedTokens = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            if (word.contains("-")) {
                String[] parts;
                isMixedCase = false;
                for (String part : parts = word.split("-")) {
                    if (!StringTools.isMixedCase((String)part)) continue;
                    isMixedCase = true;
                    break;
                }
            } else {
                isMixedCase = StringTools.isMixedCase((String)word);
            }
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, analyzedTokens);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, analyzedTokens);
            }
            if (analyzedTokens.isEmpty()) {
                this.addTokens(this.tagNumberExpressions(word), analyzedTokens);
            }
            if (analyzedTokens.isEmpty() && !isMixedCase) {
                this.addTokens(this.tagMenteAdverbs(word, lowerWord, (IStemmer)dictLookup), analyzedTokens);
            }
            if (analyzedTokens.isEmpty() && !isMixedCase) {
                this.addTokens(this.tagPrefixedVerbs(word, (IStemmer)dictLookup), analyzedTokens);
                if (!analyzedTokens.isEmpty()) {
                    ignoreSpelling = true;
                }
            }
            if (analyzedTokens.isEmpty()) {
                analyzedTokens.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(analyzedTokens, pos);
            if (ignoreSpelling) {
                atr.ignoreSpelling();
            }
            if (containsTypewriterApostrophe) {
                ArrayList<ChunkTag> listChunkTags = new ArrayList<ChunkTag>();
                listChunkTags.add(new ChunkTag("containsTypewriterApostrophe"));
                atr.setChunkTags(listChunkTags);
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    private List<AnalyzedToken> tagMenteAdverbs(String word, String lowerWord, IStemmer dictLookup) {
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        if (word.endsWith("mente")) {
            String possibleAdj = lowerWord.replaceAll("^(.+)mente$", "$1");
            List taggerTokens = this.asAnalyzedTokenList(lowerWord, dictLookup.lookup((CharSequence)possibleAdj));
            for (AnalyzedToken taggerToken : taggerTokens) {
                Matcher m;
                String posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = ADJ_PART_FS.matcher(posTag)).matches()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, "RG", lowerWord));
                return additionalTaggedTokens;
            }
        }
        return additionalTaggedTokens;
    }

    private List<AnalyzedToken> tagPrefixedVerbs(String word, IStemmer dictLookup) {
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        Matcher matcher = PREFIXES_FOR_VERBS.matcher(word);
        if (matcher.matches()) {
            String prefix = matcher.group(1).toLowerCase();
            String possibleVerb = matcher.group(2).toLowerCase();
            List taggerTokens = this.asAnalyzedTokenList(possibleVerb, dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                String lemma;
                Matcher m;
                String posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches() || !dictLookup.lookup((CharSequence)(lemma = prefix + taggerToken.getLemma())).isEmpty()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
        }
        return additionalTaggedTokens;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

